# import json
# import re
#
#
# # --- Helper for joining lists with "and" ---
# def _join_with_and(items_list):
#     if not items_list:
#         return ""
#     if len(items_list) == 1:
#         return items_list[0]
#     items_copy = list(items_list)
#     last_item = items_copy.pop()
#     if not items_copy:
#         return last_item
#     return f"{', '.join(items_copy)} and {last_item}"
#
#
# # --- Individual Amenity Formatters ---
#
# def _format_basic_amenity(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     description = sub_amenities.get('description')
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_with_description(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     description = sub_amenities.get('description')
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_tv(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     type_val = sub_amenities.get('type')
#     size = sub_amenities.get('size')
#     streaming_services = sub_amenities.get('streamingServices', [])
#     description = sub_amenities.get('description')
#
#     result = amenity
#
#     if size:
#         size_str = str(size)
#         if type_val and isinstance(type_val, str) and 'hd' in type_val.lower():
#             result = f"{size_str}-inch HDTV"
#         elif type_val and isinstance(type_val, str) and 'standard' in type_val.lower():
#             result = f"{size_str}-inch Standard TV"
#         else:
#             result = f"{size_str}-inch {result}"
#     else:
#         if type_val and isinstance(type_val, str) and 'hd' in type_val.lower():
#             result = 'HDTV'
#         elif type_val and isinstance(type_val, str) and 'standard' in type_val.lower():
#             result = 'Standard TV'
#
#     if streaming_services:
#         result = f"{result} with {_join_with_and(streaming_services)}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_pool(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     privacy = sub_amenities.get('privacy')
#     access = sub_amenities.get('access')
#     features = sub_amenities.get('features', [])
#     availability = sub_amenities.get('availability')
#     hours_of_use = sub_amenities.get('hoursOfUse')
#     seasonal_availability = sub_amenities.get('seasonalAvailability')
#     description = sub_amenities.get('description')
#
#     result = amenity.lower()
#
#     if access:
#         result = f"{access} {result}"
#     if privacy:
#         result = f"{privacy} {result}"
#
#     attributes_list = []
#     if availability:
#         attributes_list.append(availability)
#     if hours_of_use:
#         attributes_list.append(hours_of_use)
#     if features:
#         attributes_list.extend(features)
#
#     if attributes_list:
#         result = f"{result} – {', '.join(attributes_list)}"
#
#     desc_to_use = f"Available from {seasonal_availability}" if seasonal_availability else description
#     return {'formatted': result, 'description': desc_to_use}
#
#
# def _format_air_conditioning(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     type_val = sub_amenities.get('type')
#     description = sub_amenities.get('description')
#
#     def format_single_ac_type(ac_type_str):
#         # Ensure ac_type_str is a string for comparison and processing
#         ac_type_str_processed = str(ac_type_str)
#         if ac_type_str_processed.lower() == "split-type ductless system":
#             return "AC – split-type ductless system"
#         # For other types like "Central air conditioning", "Portable air conditioning", "Window AC unit"
#         # return them as is.
#         return ac_type_str_processed
#
#     if type_val:
#         if isinstance(type_val, list):
#             if not type_val:  # Handles empty list case
#                 # Fallback to the generic amenity name if the type list is empty
#                 return {'formatted': amenity, 'description': description}
#
#             # Process each type in the list and return a list of formatted items
#             # Each item in the returned list will be a dictionary
#             # The main loop in format_airbnb_amenities_from_json_string will unpack this.
#             return [{'formatted': format_single_ac_type(t), 'description': description} for t in type_val]
#
#         # Single string type
#         return {'formatted': format_single_ac_type(type_val), 'description': description}
#
#     # No type_val provided, or it was an empty string initially
#     # Fallback to the generic amenity name
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_wifi(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     speed = sub_amenities.get('speed')
#     quality = sub_amenities.get('quality')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if quality:
#         result = f"{quality} {result.lower()}"
#     if speed:
#         result = f"{result} – {speed} Mbps"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_bbq_grill(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     privacy = sub_amenities.get('privacy')
#     type_val = sub_amenities.get('type')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if type_val:
#         result = f"{type_val} {result}"
#     if privacy:
#         result = f"{privacy} {result}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_beach_access(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     privacy = sub_amenities.get('privacy')
#     beachfront = sub_amenities.get('beachfront')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if privacy:
#         result = f"{privacy} {result}"
#     if beachfront:
#         result = f"{result} – {beachfront}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_bed_linen(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     material = sub_amenities.get('material')
#     brand = sub_amenities.get('brand')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     prefix_parts = []
#     if material:
#         prefix_parts.append(material)
#     if brand:
#         prefix_parts.append(brand)
#
#     if prefix_parts:
#         result = f"{' '.join(prefix_parts)} {result}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_coffee_maker(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     type_val = sub_amenities.get('type')
#     description = sub_amenities.get('description')
#
#     if type_val:
#         if isinstance(type_val, list):
#             return {'formatted': f"{amenity}: {_join_with_and(type_val)}", 'description': description}
#         return {'formatted': f"{amenity}: {type_val}", 'description': description}
#
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_cooker(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     brand = sub_amenities.get('brand')
#     type_val = sub_amenities.get('type')
#     num_burners = sub_amenities.get('numberOfBurners')
#     material = sub_amenities.get('material')
#     description = sub_amenities.get('description')
#
#     parts = []
#     if brand: parts.append(brand)
#     if material: parts.append(material)
#     if type_val: parts.append(type_val)
#     parts.append(amenity)
#
#     result = " ".join(parts)
#
#     if num_burners:
#         result = f"{result} with {num_burners} burners"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_cot(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     size = sub_amenities.get('size')
#     availability = sub_amenities.get('availability')
#     features = sub_amenities.get('features', [])
#     price = sub_amenities.get('price')
#     privacy = sub_amenities.get('privacy')
#     type_val = sub_amenities.get('type')
#     dimensions = sub_amenities.get('dimensions')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if price: result = f"{price} {result}"
#     if type_val: result = f"{type_val} {result}"
#     if size: result = f"{size} {result}"
#     if privacy: result = f"{privacy} {result}"
#     if availability: result = f"{result} – {availability}"
#
#     detailed_description = description or ""
#     if dimensions:
#         detailed_description = dimensions
#     if features:
#         if detailed_description: detailed_description += ", "
#         detailed_description += ", ".join(features)
#
#     return {'formatted': result, 'description': detailed_description if detailed_description else None}
#
#
# def _format_workspace(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     location = sub_amenities.get('location')
#     setup = sub_amenities.get('setup', [])
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if location:
#         result = f"{result} in a {location} space"
#     if setup:
#         result = f"{result} with {_join_with_and(setup)}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_dining_table(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     num_spaces = sub_amenities.get('numberOfSpaces')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if num_spaces:
#         result = f"{result} – {num_spaces} spaces"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_laundry_appliance(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     price = sub_amenities.get('price')
#     location = sub_amenities.get('location')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if price:
#         result = f"{price} {result}"
#     if location:
#         result = f"{result} – {location}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_ev_charger(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     type_val = sub_amenities.get('type')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if type_val:
#         result = f"{result} – {type_val}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_exercise_equipment(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     # 'type' is expected to be a list of selected equipment, e.g., ["Elliptical", "Treadmill", "Rowing"]
#     type_val = sub_amenities.get('type', [])
#     description = sub_amenities.get('description')
#
#     if type_val and isinstance(type_val, list) and len(type_val) > 0:
#         # Join the list of equipment types with a comma and space
#         # Convert each item to string to be safe, though they should be strings
#         formatted_types = ", ".join(str(t).lower() for t in type_val)  # Make them lowercase as in example
#         return {'formatted': f"{amenity}: {formatted_types}", 'description': description}
#     elif type_val and isinstance(type_val, str):  # Handle if type_val is accidentally a single string
#         return {'formatted': f"{amenity}: {str(type_val).lower()}", 'description': description}
#
#     # If no types are provided or type_val is an empty list, just return the base amenity name
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_parking(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     type_val = sub_amenities.get('type')
#     num_spaces = sub_amenities.get('numberOfSpaces')
#     description = sub_amenities.get('description')
#
#     result = amenity
#
#     is_price_included = "free" in result.lower() or "paid" in result.lower()
#
#     if type_val:
#         if is_price_included:
#             parts = result.split(' ', 1)
#             if len(parts) == 2:
#                 price_word = parts[0]
#                 rest_of_amenity = parts[1]
#                 result = f"{price_word} {type_val} {rest_of_amenity}"
#             else:
#                 result = f"{type_val} {result}"
#         else:
#             result = f"{type_val} {result}"
#
#     if num_spaces:
#         result = f"{result} – {num_spaces} spaces"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_garden(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     privacy = sub_amenities.get('privacy')
#     fully_fenced = sub_amenities.get('fullyFenced')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if privacy:
#         result = f"{privacy} {result}"
#     if fully_fenced and str(fully_fenced).lower() == 'yes':
#         result = f"{result} – Fully fenced"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_gym(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     privacy = sub_amenities.get('privacy')
#     location = sub_amenities.get('location')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if privacy:
#         result = f"{privacy} {result}"
#     if location:
#         result = f"{result} {location}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_heating(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     type_val = sub_amenities.get('type')
#     description = sub_amenities.get('description')
#
#     if type_val:
#         if isinstance(type_val, list):
#             return {'formatted': _join_with_and(type_val), 'description': description}
#         return {'formatted': str(type_val), 'description': description}
#
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_high_chair(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     type_val = sub_amenities.get('type')
#     availability = sub_amenities.get('availability')
#     features = sub_amenities.get('features', [])
#     price = sub_amenities.get('price')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if price: result = f"{price} {result}"
#     if type_val: result = f"{type_val} {result}"
#     if availability: result = f"{result} – {availability}"
#
#     detailed_description = description or ""
#     if features:
#         detailed_description = f"With {_join_with_and(features)}"
#
#     return {'formatted': result, 'description': detailed_description if detailed_description else None}
#
#
# def _format_hot_tub(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     privacy = sub_amenities.get('privacy')
#     num_persons = sub_amenities.get('numberOfPersons')
#     hours_of_use = sub_amenities.get('hoursOfUse')
#     availability = sub_amenities.get('availability')
#     seasonal_availability = sub_amenities.get('seasonalAvailability')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if privacy:
#         result = f"{privacy} {result}"
#
#     details = []
#     if availability: details.append(availability)
#     if hours_of_use: details.append(hours_of_use)
#
#     if details:
#         result = f"{result} – {', '.join(details)}"
#
#     desc_to_use = f"Available from {seasonal_availability}" if seasonal_availability else description
#
#     return {'formatted': result, 'description': desc_to_use}
#
#
# def _format_fireplace(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     type_val = sub_amenities.get('type')
#     description = sub_amenities.get('description')
#
#     if type_val:
#         if isinstance(type_val, list):
#             return {'formatted': f"{amenity}: {_join_with_and(type_val)}", 'description': description}
#         return {'formatted': f"{amenity}: {type_val}", 'description': description}
#
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_outdoor_dining(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     num_spaces = sub_amenities.get('numberOfSpaces')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if num_spaces:
#         result = f"{result} – {num_spaces} spaces"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_outdoor_kitchen(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     privacy = sub_amenities.get('privacy')
#     features = sub_amenities.get('features', [])
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if privacy:
#         result = f"{privacy} {result}"
#     if features:
#         result = f"{result} with {_join_with_and(features)}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_oven(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     material = sub_amenities.get('material')
#     brand = sub_amenities.get('brand')
#     type_val = sub_amenities.get('type')
#     description = sub_amenities.get('description')
#
#     parts = []
#     if brand: parts.append(brand)
#     if material: parts.append(material)
#     if type_val: parts.append(type_val)
#     parts.append(amenity)
#
#     result = " ".join(parts)
#     return {'formatted': result, 'description': description}
#
#
# def _format_patio_balcony(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     privacy = sub_amenities.get('privacy')
#     description = sub_amenities.get('description')
#
#     if privacy:
#         return {'formatted': f"{privacy} {amenity.lower()}", 'description': description}
#
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_piano(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     brand = sub_amenities.get('brand')
#     type_val = sub_amenities.get('type')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     prefix_parts = []
#     if type_val: prefix_parts.append(type_val)
#     if brand: prefix_parts.append(brand)
#
#     if prefix_parts:
#         result = f"{' '.join(prefix_parts)} {result.lower() if len(prefix_parts) > 0 else result}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_sauna(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     privacy = sub_amenities.get('privacy')
#     description = sub_amenities.get('description')
#
#     if privacy:
#         return {'formatted': f"{privacy} {amenity.lower()}", 'description': description}
#
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_sound_system(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     brand = sub_amenities.get('brand')
#     connectivity = sub_amenities.get('connectivity', [])
#     description = sub_amenities.get('description')
#
#     result = amenity.lower()
#     if brand:
#         result = f"{brand} {result}"
#     if connectivity:
#         result = f"{result} with {_join_with_and(connectivity)}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_games_console(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     type_val = sub_amenities.get('type', [])
#     description = sub_amenities.get('description')
#
#     if type_val:
#         return {'formatted': f"{amenity}: {_join_with_and(type_val)}", 'description': description}
#
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_refrigerator(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     brand = sub_amenities.get('brand')
#     description = sub_amenities.get('description')
#
#     if brand:
#         return {'formatted': f"{brand} {amenity.lower()}", 'description': description}
#
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_toiletries(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     brand = sub_amenities.get('brand')
#     description = sub_amenities.get('description')
#
#     if brand:
#         return {'formatted': f"{brand} {amenity.lower()}", 'description': description}
#
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_children_items(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     age_group = sub_amenities.get('ageGroup', [])
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if age_group:
#         result = f"{result} for ages {_join_with_and(age_group)}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_baby_item(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     availability = sub_amenities.get('availability')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if availability:
#         result = f"{result} – {availability}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_clothes_storage(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     type_val = sub_amenities.get('type', [])
#     description = sub_amenities.get('description')
#
#     if type_val:
#         return {'formatted': f"{amenity}: {_join_with_and(type_val)}", 'description': description}
#
#     return {'formatted': amenity, 'description': description}
#
#
# def _format_ski_access(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     location = sub_amenities.get('location')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if location:
#         result = f"{result} – {location}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_resort_access(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     price = sub_amenities.get('price')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if price:
#         if price.lower() != "included":
#             result = f"{price} {result.lower()}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_boat_berth(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     privacy = sub_amenities.get('privacy')
#     description = sub_amenities.get('description')
#
#     result = amenity
#     if privacy:
#         result = f"{privacy} {result.lower()}"
#
#     return {'formatted': result, 'description': description}
#
#
# def _format_housekeeping(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     price = sub_amenities.get('price')
#     availability = sub_amenities.get('availability')
#     time_range = sub_amenities.get('timeRange')
#     frequency = sub_amenities.get('frequency')
#     description = sub_amenities.get('description')
#
#     def format_specific_days_array(days_array):
#         if not isinstance(days_array, list) or not days_array:
#             return ""
#
#         day_order = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
#         normalized_days_array = [d.capitalize() for d in days_array if isinstance(d, str)]
#
#         sorted_indices = sorted(
#             [day_order.index(d) for d in normalized_days_array if d in day_order]
#         )
#
#         if not sorted_indices:
#             return ""
#
#         is_consecutive = True
#         for i in range(len(sorted_indices) - 1):
#             if sorted_indices[i + 1] != sorted_indices[i] + 1:
#                 if not (len(sorted_indices) == 2 and sorted_indices[0] == 0 and sorted_indices[1] == 6):
#                     is_consecutive = False
#                     break
#
#         if is_consecutive and len(sorted_indices) > 1:
#             if len(sorted_indices) == 2 and sorted_indices[0] == 0 and sorted_indices[1] == 6:
#                 return f"{day_order[sorted_indices[1]]} to {day_order[sorted_indices[0]]}"
#             return f"{day_order[sorted_indices[0]]} to {day_order[sorted_indices[-1]]}"
#         else:
#             return ", ".join([day_order[i] for i in sorted_indices])
#
#     base = f"{amenity} available"
#     details = []
#
#     # 1. Hours of service (timeRange)
#     if time_range:
#         formatted_time_range_str = str(time_range)
#         if formatted_time_range_str.lower() != "24 hours":
#             def format_time(time_str_param):
#                 return re.sub(r'\s+(am|pm)', '\u202F\\1', time_str_param, flags=re.IGNORECASE)
#
#             if " to " in formatted_time_range_str:
#                 part1, part2 = formatted_time_range_str.split(" to ", 1)
#                 formatted_time_range_str = f"from {format_time(part1.strip())} to {format_time(part2.strip())}"
#             else:
#                 formatted_time_range_str = f"from {format_time(formatted_time_range_str)}"
#         details.append(formatted_time_range_str)
#
#     # 2. Day-level availability
#     # Prioritize specific days (availability list) if provided
#     if isinstance(availability, list) and availability:
#         availability_detail_str = format_specific_days_array(availability)
#         if availability_detail_str:
#             details.append(availability_detail_str)
#     elif frequency:  # If specific days not given, use frequency
#         if isinstance(frequency, int) or (isinstance(frequency, str) and frequency.isdigit()):
#             details.append(f"{int(frequency)} days a week")
#         else:  # e.g., "Daily", "Weekly"
#             details.append(str(frequency))
#
#     formatted = base
#     if details:
#         formatted = f"{formatted} {', '.join(details)}"
#
#     included_strings = ["included with your stay", "included"]
#     if price and str(price).lower().strip() not in included_strings:
#         formatted = f"{formatted} – {price}"
#
#     return {'formatted': formatted.strip(), 'description': description}
#
#
# # --- Default Formatter ---
# def _default_formatter(amenity, sub_amenities=None):
#     sub_amenities = sub_amenities or {}
#     type_val = sub_amenities.get('type')
#     brand = sub_amenities.get('brand')
#     privacy = sub_amenities.get('privacy')
#     features = sub_amenities.get('features', [])
#     location = sub_amenities.get('location')
#     price = sub_amenities.get('price')
#     availability = sub_amenities.get('availability')
#     description = sub_amenities.get('description')
#     num_spaces = sub_amenities.get('numberOfSpaces')
#
#     result = amenity
#
#     prefix_parts = []
#     if price: prefix_parts.append(price)
#     if brand: prefix_parts.append(brand)
#     if type_val:
#         if isinstance(type_val, list):
#             prefix_parts.append(_join_with_and(type_val))
#         else:
#             prefix_parts.append(str(type_val))
#     if privacy: prefix_parts.append(privacy)
#
#     if prefix_parts:
#         result = f"{' '.join(prefix_parts)} {result.lower() if any(p for p in [price, brand, type_val, privacy]) else result}"
#
#     suffix_parts = []
#     if location: suffix_parts.append(location)
#     if availability: suffix_parts.append(availability)
#     if num_spaces: suffix_parts.append(f"{num_spaces} spaces")
#
#     if suffix_parts:
#         result = f"{result} – {', '.join(suffix_parts)}"
#
#     if features:
#         result = f"{result} with {_join_with_and(features)}"
#
#     return {'formatted': result, 'description': description}
#
#
# # --- Main Dispatcher ---
# _SPECIAL_FORMATTERS = {
#     # Bathroom amenities
#     'TV': _format_tv,
#     'Bath': _format_basic_amenity,
#     'Hair dryer': _format_basic_amenity,
#     'Cleaning products': _format_basic_amenity,
#     'Shampoo': _format_toiletries,
#     'Conditioner': _format_toiletries,
#     'Body soap': _format_toiletries,
#     'Bidet': _format_basic_amenity,
#     'Outdoor shower': _format_basic_amenity,
#     'Hot water': _format_basic_amenity,
#     'Shower gel': _format_basic_amenity,
#
#     # Bedroom and laundry amenities
#     'Washer': _format_laundry_appliance,
#     'Dryer': _format_laundry_appliance,
#     'Essentials': _format_with_description,
#     'Hangers': _format_basic_amenity,
#     'Bed linen': _format_bed_linen,
#     'Extra pillows and blankets': _format_basic_amenity,
#     'Room-darkening blinds': _format_basic_amenity,
#     'Iron': _format_basic_amenity,
#     'Clothes drying rack': _format_basic_amenity,
#     'Safe': _format_basic_amenity,
#     'Mosquito net': _format_basic_amenity,
#     'Clothes storage': _format_clothes_storage,
#
#     # Entertainment amenities
#     'Ethernet connection': _format_basic_amenity,
#     'Piano': _format_piano,
#     'Record player': _format_basic_amenity,
#     'Sound system': _format_sound_system,
#     'Games console': _format_games_console,
#     'Exercise equipment': _format_exercise_equipment,
#     'Ping pong table': _format_basic_amenity,
#     'Pool table': _format_basic_amenity,
#     'Books and reading material': _format_basic_amenity,
#     'Cinema': _format_basic_amenity,
#     'Bowling alley': _format_basic_amenity,
#     'Theme room': _format_with_description,
#     'Life-size games': _format_basic_amenity,
#     'Skate ramp': _format_basic_amenity,
#     'Mini golf': _format_basic_amenity,
#     'Laser tag': _format_basic_amenity,
#     'Batting cage': _format_basic_amenity,
#     'Arcade games': _format_basic_amenity,
#
#     # Family amenities
#     'Cot': _format_cot,
#     'Travel cot': _format_cot,
#     'Children\'s books and toys': _format_children_items,
#     'High chair': _format_high_chair,
#     'Baby bath': _format_baby_item,
#     'Children\'s tableware': _format_basic_amenity,
#     'Changing table': _format_baby_item,
#     'Baby monitor': _format_baby_item,
#     'Fireplace guards': _format_basic_amenity,
#     'Window guards': _format_basic_amenity,
#     'Plug socket covers': _format_basic_amenity,
#     'Board games': _format_basic_amenity,
#     'Baby safety gates': _format_basic_amenity,
#     'Table corner guards': _format_basic_amenity,
#     'Babysitter recommendations': _format_basic_amenity,
#     'Children\'s playroom': _format_with_description,
#     'Outdoor playground': _format_with_description,
#     'Children\'s bikes': _format_basic_amenity,
#     'Fire screen': _format_basic_amenity,
#
#     # Heating and cooling amenities
#     'Air Conditioning': _format_air_conditioning,
#     'Indoor fireplace': _format_fireplace,
#     'Ceiling fan': _format_basic_amenity,
#     'Portable fans': _format_basic_amenity,
#     'Heating': _format_heating,
#     'Central heating': _format_basic_amenity,
#     'Radiant heating': _format_basic_amenity,
#     'Portable heater': _format_basic_amenity,
#
#     # Home safety amenities
#     'Smoke alarm': _format_basic_amenity,
#     'Carbon monoxide alarm': _format_basic_amenity,
#     'Fire extinguisher': _format_basic_amenity,
#     'First aid kit': _format_basic_amenity,
#
#     # Internet and office amenities
#     'Wifi': _format_wifi,
#     'Dedicated workspace': _format_workspace,
#     'Pocket wifi': _format_basic_amenity,
#
#     # Kitchen and dining amenities
#     'Kitchen': _format_with_description,
#     'Refrigerator': _format_refrigerator,
#     'Microwave': _format_basic_amenity,
#     'Cooking basics': _format_with_description,
#     'Dishes and cutlery': _format_with_description,
#     'Mini fridge': _format_basic_amenity,
#     'Freezer': _format_basic_amenity,
#     'Dishwasher': _format_basic_amenity,
#     'Cooker': _format_cooker,
#     'Oven': _format_oven,
#     'Kettle': _format_basic_amenity,
#     'Coffee maker': _format_coffee_maker,
#     'Wine glasses': _format_basic_amenity,
#     'Toaster': _format_basic_amenity,
#     'Baking sheet': _format_basic_amenity,
#     'Blender': _format_basic_amenity,
#     'Rice cooker': _format_basic_amenity,
#     'Rice Maker': _format_basic_amenity,
#     'Waste compactor': _format_basic_amenity,
#     'Barbecue utensils': _format_with_description,
#     'Dining table': _format_dining_table,
#     'Coffee': _format_basic_amenity,
#     'Bread maker': _format_basic_amenity,
#
#     # Location features
#     'Waterfront': _format_with_description,
#     'Beach access': _format_beach_access,
#     'Lake access': _format_with_description,
#     'Ski-in/out': _format_ski_access,
#     'Private entrance': _format_with_description,
#     'Launderette nearby': _format_basic_amenity,
#     'Resort access': _format_resort_access,
#
#     # Outdoor amenities
#     'Pool': _format_pool,
#     'BBQ grill': _format_bbq_grill,
#     'Garden': _format_garden,
#     'Patio or balcony': _format_patio_balcony,
#     'Firepit': _format_basic_amenity,
#     'Outdoor furniture': _format_basic_amenity,
#     'Hammock': _format_basic_amenity,
#     'Outdoor dining area': _format_outdoor_dining,
#     'Outdoor kitchen': _format_outdoor_kitchen,
#     'Beach essentials': _format_with_description,
#     'Kayak': _format_basic_amenity,
#     'Boat berth': _format_boat_berth,
#     'Sun loungers': _format_basic_amenity,
#
#     # Parking and facilities
#     'Free parking on premises': _format_parking,
#     'Free on-street parking': _format_basic_amenity,
#     'Paid parking on premises': _format_parking,
#     'Paid parking off premises': _format_parking,
#     'Hot tub': _format_hot_tub,
#     'Sauna': _format_sauna,
#     'Lift': _format_with_description,
#     'EV charger': _format_ev_charger,
#     'Gym': _format_gym,
#     'Single level home': _format_with_description,
#     'Ice hockey rink': _format_basic_amenity,
#
#     # Services
#     'Luggage drop-off allowed': _format_with_description,
#     'Breakfast': _format_with_description,
#     'Long-term stays allowed': _format_with_description,
#     'Cleaning available during stay': _format_housekeeping,
#     'Housekeeping': _format_housekeeping
# }
#
#
# def _format_single_amenity_item(options):
#     amenity_name = options.get('amenity')
#     sub_amenities = options.get('subAmenities', {})
#
#     if not amenity_name:
#         # Return a structure that the main loop can handle, even for errors
#         return {'formatted': "Error: Amenity name missing", 'description': None}
#
#     formatter_func = _SPECIAL_FORMATTERS.get(amenity_name, _default_formatter)
#
#     if sub_amenities is None:  # Should be caught by .get default, but for safety
#         sub_amenities = {}
#
#     return formatter_func(amenity_name, sub_amenities)
#
#
# def format_airbnb_amenities_from_json_string(json_input_string):
#     try:
#         amenity_data_list = json.loads(json_input_string)
#     except json.JSONDecodeError as e:
#         return [f"Error: Invalid JSON input - {e}"]
#
#     if not isinstance(amenity_data_list, list):
#         return ["Error: JSON input must be a list of amenity objects."]
#
#     formatted_strings_list = []
#     for amenity_options in amenity_data_list:
#         if not isinstance(amenity_options, dict):
#             formatted_strings_list.append("Error: Each item in the list must be an amenity object (dict).")
#             continue
#
#         # _format_single_amenity_item calls the specific formatter.
#         # The formatter might return a single dict {'formatted': ..., 'description': ...}
#         # OR a list of such dicts (e.g., for Air Conditioning with multiple types)
#         processed_item_or_list = _format_single_amenity_item(amenity_options)
#
#         if isinstance(processed_item_or_list, list):
#             # This case handles formatters that return multiple lines (e.g., Air Conditioning)
#             for item_dict in processed_item_or_list:
#                 if isinstance(item_dict, dict) and 'formatted' in item_dict:
#                     formatted_strings_list.append(item_dict['formatted'])
#                 else:
#                     # This error indicates a problem with how a multi-line formatter structured its output
#                     formatted_strings_list.append(f"Error: Malformed sub-item for {amenity_options.get('amenity')}.")
#         elif isinstance(processed_item_or_list, dict) and 'formatted' in processed_item_or_list:
#             # Standard case: formatter returned a single item
#             formatted_strings_list.append(processed_item_or_list['formatted'])
#         else:
#             # This error indicates an unexpected return type from a formatter
#             formatted_strings_list.append(f"Error: Malformed item from formatter for {amenity_options.get('amenity')}.")
#
#     return formatted_strings_list
#
#
#
#
# #####################################################################################################################
#
#
#
# import pandas as pd
# import json
# import re
# import numpy as np
# import mysql.connector # Added for MySQL connection
# # from ast import literal_eval # Not needed anymore for test_df processing
#
# # --- Placeholder for your external amenity formatter ---
# # Ensure this function is defined or imported in your actual script
# # For example:
# # from your_amenity_formatter_module import format_airbnb_amenities_from_json_string
#
#
#
# def get_top_amenities(df, db_config):
#     """
#     Analyze top missing amenities by price and revenue impact.
#
#     Parameters:
#     - df: pandas DataFrame - Main data loaded from SQL database
#     - db_config: dict - Database connection configuration for fetching test amenities
#                      Example: {'host': 'localhost', 'user': 'root', 'password': '', 'database': 'pricing'}
#
#     Returns:
#     - JSON string with top 10 missing amenities by price and revenue impact
#     """
#     # -------------------- Precompiled Patterns --------------------
#     pattern = re.compile(r"[\s\-:]+")
#     normalize = lambda x: pattern.sub(" ", x.strip().lower()).lower() if isinstance(x, str) else x
#
#     # -------------------- Debug Info --------------------
#     print(f"Main DataFrame columns: {df.columns.tolist()}")
#
#     # -------------------- Amenity Processing (Main DataFrame) --------------------
#     def process_main_amenities(s):
#         try:
#             if pd.isna(s):
#                 return set()
#
#             if isinstance(s, dict) or isinstance(s, list): # Already parsed
#                 data = s
#             elif isinstance(s, str):
#                 try:
#                     data = json.loads(s)
#                 except json.JSONDecodeError:
#                     # print(f"JSON parsing failed for main amenities: {s[:100]}") # Can be noisy
#                     return set()
#             else:
#                 return set()
#
#             if isinstance(data, list): # Expected structure: list of groups
#                 result = set()
#                 for group in data:
#                     if not isinstance(group, dict):
#                         continue
#                     items = group.get("items", [])
#                     if not isinstance(items, list):
#                         continue
#                     for item in items:
#                         if isinstance(item, dict) and "name" in item:
#                             result.add(normalize(item["name"]))
#                 return result
#             return set()
#         except Exception as e:
#             print(f"Error processing main amenity: {e}")
#             return set()
#
#     print("Processing main amenities...")
#     df["amenities_set"] = df["amenities"].apply(process_main_amenities)
#     all_amenities = set().union(*df["amenities_set"].values) if len(df) > 0 and not df["amenities_set"].empty else set()
#
#     # -------------------- Amenity Processing (Test Data from SQL) --------------------
#     test_amenities_raw_list = []
#     try:
#         print(f"Connecting to database for test amenities: {db_config.get('database')} on {db_config.get('host')}")
#         conn_test = mysql.connector.connect(**db_config)
#         cursor_test = conn_test.cursor(dictionary=True) # dictionary=True to get results as dicts
#
#         query_test = "SELECT dynamicAmenity FROM userdynamiclistset ORDER BY id LIMIT 1" # Assuming an 'id' or similar for ordering
#         print(f"Executing query for test amenities: {query_test}")
#         cursor_test.execute(query_test)
#         first_row = cursor_test.fetchone()
#
#         if first_row and 'dynamicAmenity' in first_row and first_row['dynamicAmenity']:
#             dynamic_amenity_json_string = first_row['dynamicAmenity']
#             # THIS WILL NOW CALL YOUR FULL FORMATTER DEFINED ABOVE
#             test_amenities_raw_list = format_airbnb_amenities_from_json_string(dynamic_amenity_json_string)
#             print(f"Formatted test amenities count: {len(test_amenities_raw_list)}")
#             if test_amenities_raw_list:
#                 print(f"First few formatted test amenities: {test_amenities_raw_list[:5]}")
#
#         else:
#             print("No dynamicAmenity data found in userdynamiclistset or it was empty.")
#
#     except mysql.connector.Error as err:
#         print(f"MySQL Error fetching test amenities: {err}")
#     except Exception as e:
#         print(f"General Error fetching/processing test amenities: {e}")
#     finally:
#         if 'conn_test' in locals() and conn_test.is_connected():
#             cursor_test.close()
#             conn_test.close()
#             print("Test amenities database connection closed.")
#
#     test_amenities = {normalize(amenity) for amenity in test_amenities_raw_list if isinstance(amenity, str)}
#
#
#     # -------------------- Missing Amenities Calculation --------------------
#     missing_amenities = all_amenities - test_amenities
#
#     print(f"Total unique amenities in main data: {len(all_amenities)}")
#     print(f"Total unique amenities in test data (from userdynamiclistset): {len(test_amenities)}")
#     print(f"Total missing amenities: {len(missing_amenities)}")
#     if not missing_amenities and (all_amenities and test_amenities):
#         print("Note: No missing amenities found. Test data might cover all main amenities or vice-versa.")
#     elif not all_amenities:
#         print("Warning: No amenities processed from the main dataframe.")
#     elif not test_amenities:
#         print("Warning: No amenities processed from the test data source (userdynamiclistset).")
#
#
#     # -------------------- Impact Calculation --------------------
#     price_impacts = {}
#     revenue_impacts = {}
#
#     if not missing_amenities:
#         print("Skipping impact calculation as there are no missing amenities to analyze.")
#     elif df.empty or 'amenities_set' not in df.columns or df['amenities_set'].apply(len).sum() == 0:
#         print("Skipping impact calculation as main dataframe is empty or has no processed amenities.")
#     else:
#         try:
#             # Ensure required columns exist in main df
#             for col in ["price", "total_revenue"]:
#                 if col not in df.columns:
#                     print(f"Creating missing column in main df: {col} with default 0")
#                     df[col] = 0
#                 # Convert to numeric, coercing errors to NaN, then fill NaN with 0
#                 df[col] = pd.to_numeric(df[col], errors='coerce').fillna(0)
#
#
#             print("Exploding amenities for impact calculation...")
#             # Filter out rows where amenities_set is empty before exploding
#             df_with_amenities = df[df['amenities_set'].apply(lambda x: bool(x))]
#             if df_with_amenities.empty:
#                 print("No listings with amenities found in main data. Skipping impact calculation.")
#             else:
#                 exploded = df_with_amenities.explode("amenities_set")[["amenities_set", "price", "total_revenue"]].copy()
#                 exploded = exploded[exploded["amenities_set"].notna() & (exploded["amenities_set"] != "")] # Should be redundant due to previous filter
#
#                 if exploded.empty:
#                     print("Exploded dataframe is empty. Cannot calculate impact.")
#                 else:
#                     print("Calculating group statistics...")
#                     stats = exploded.groupby("amenities_set").agg(
#                         price_sum=("price", "sum"),
#                         price_count=("price", "count"),
#                         revenue_sum=("total_revenue", "sum"),
#                         revenue_count=("total_revenue", "count") # Assuming total_revenue is also per listing
#                     )
#
#                     # Calculate price impact
#                     total_price_main_df = df["price"].sum() # Use original df for total, not exploded
#                     total_listings_main_df = len(df)      # Use original df for total, not exploded
#
#                     def calculate_price_impact(row):
#                         try:
#                             if row["price_count"] <= 0 or (total_listings_main_df - row["price_count"]) <= 0:
#                                 return 0
#                             avg_with_amenity = row["price_sum"] / row["price_count"]
#                             avg_without_amenity = (total_price_main_df - row["price_sum"]) / (total_listings_main_df - row["price_count"])
#                             if avg_without_amenity == 0: # Avoid division by zero; if base is 0, impact is undefined or infinite
#                                 return np.nan # Or a large number if preferred, or 0 if it means no negative impact
#                             return ((avg_with_amenity - avg_without_amenity) / avg_without_amenity) * 100
#                         except ZeroDivisionError:
#                             return np.nan # Handle cases where counts lead to division by zero
#                         except Exception as e:
#                             # print(f"Error calculating price impact for {row.name}: {e}")
#                             return np.nan
#
#                     print("Calculating price impact...")
#                     stats["price_impact"] = stats.apply(calculate_price_impact, axis=1)
#
#                     # Calculate revenue impact
#                     total_revenue_main_df = df["total_revenue"].sum()
#
#                     def calculate_revenue_impact(row):
#                         try:
#                             if row["revenue_count"] <= 0 or (total_listings_main_df - row["revenue_count"]) <= 0:
#                                 return 0
#                             avg_with_amenity = row["revenue_sum"] / row["revenue_count"]
#                             avg_without_amenity = (total_revenue_main_df - row["revenue_sum"]) / (total_listings_main_df - row["revenue_count"])
#                             if avg_without_amenity == 0:
#                                 return np.nan
#                             return ((avg_with_amenity - avg_without_amenity) / avg_without_amenity) * 100
#                         except ZeroDivisionError:
#                             return np.nan
#                         except Exception as e:
#                             # print(f"Error calculating revenue impact for {row.name}: {e}")
#                             return np.nan
#
#                     print("Calculating revenue impact...")
#                     stats["revenue_impact"] = stats.apply(calculate_revenue_impact, axis=1)
#
#                     # -------------------- Filter and Sort Results --------------------
#                     def get_top_amenities_list(impact_series, n=10):
#                         # Filter for only those amenities that are in the 'missing_amenities' set
#                         filtered_impact = impact_series[impact_series.index.isin(missing_amenities)]
#                         return (
#                             filtered_impact.replace([np.inf, -np.inf], np.nan) # Replace inf with NaN
#                             .dropna() # Remove NaN values
#                             .sort_values(ascending=False)
#                             .head(n)
#                             .to_dict()
#                         )
#
#                     print("Finding top amenities...")
#                     price_impacts = get_top_amenities_list(stats["price_impact"])
#                     revenue_impacts = get_top_amenities_list(stats["revenue_impact"])
#         except Exception as e:
#             print(f"Error during impact calculation: {e}")
#             import traceback
#             traceback.print_exc()
#             # price_impacts and revenue_impacts remain empty dicts
#
#     print("Generating final JSON response...")
#     return json.dumps({
#         "top_10_missing_by_price": {k: f"{v:.2f}%" for k, v in price_impacts.items()},
#         "top_10_missing_by_revenue": {k: f"{v:.2f}%" for k, v in revenue_impacts.items()}
#     }, indent=2, ensure_ascii=False)
#
#
# # Example usage (you'll need to adapt this to your environment):
# if __name__ == '__main__':
#     # --- Database Configuration ---
#     db_config_main = {
#         'host': '127.0.0.1',
#         'user': 'root',
#         'password': '',  # Add your password if needed
#         'database': 'pricing'
#     }
#     # The same db_config can be used if userdynamiclistset is in the same database,
#     # or define a separate one if it's in a different database.
#     db_config_test = db_config_main # Assuming same database for simplicity
#
#     # --- Fetch Main Data ---
#     df_main = pd.DataFrame() # Initialize an empty DataFrame
#     try:
#         print("Connecting to main database...")
#         connection_main = mysql.connector.connect(**db_config_main)
#         query_main = "SELECT id, amenities, price, total_revenue FROM rental_properties" # Select only needed columns
#         print(f"Executing main data query: {query_main}")
#         df_main = pd.read_sql_query(query_main, connection_main)
#         print(f"Fetched {len(df_main)} rows for main data.")
#     except mysql.connector.Error as err:
#         print(f"MySQL Error fetching main data: {err}")
#     except Exception as e:
#         print(f"General error fetching main data: {e}")
#     finally:
#         if 'connection_main' in locals() and connection_main.is_connected():
#             connection_main.close()
#             print("Main database connection closed.")
#
#     if not df_main.empty:
#         # Call the function
#         result_json = get_top_amenities(df_main.copy(), db_config_test) # Pass a copy to avoid SettingWithCopyWarning
#         print("\n--- Analysis Result ---")
#         print(result_json)
#     else:
#         print("Could not fetch main data, skipping analysis.")
#
#     # --- Example of how format_airbnb_amenities_from_json_string might be used by get_top_amenities ---
#     print("\n--- Testing format_airbnb_amenities_from_json_string (mock) ---")
#     sample_dynamic_amenity_json = """
#     [
#         {"amenity":"Air Conditioning","subAmenities":{"type":["Window AC unit", "Portable AC unit"]}},
#         {"amenity":"Wifi","subAmenities":{"quality":"Fast"}},
#         {"amenity":"Kitchen"}
#     ]
#     """
#     formatted_list_example = format_airbnb_amenities_from_json_string(sample_dynamic_amenity_json)
#     print(f"Example formatted list: {formatted_list_example}")
#
#
#
# ##################################################################################################
#
#
#
# #--- Example Usage ---
# # if __name__ == '__main__':
# #     json_input_example = """
# #     [
# #         {"amenity":"Air Conditioning","subAmenities":{"type":["Window AC unit", "Portable air conditioning", "Split-type ductless system", "Central air conditioning"]}},
# #         {"amenity":"Air Conditioning","subAmenities":{"type": ["Central air conditioning"]}},
# #         {"amenity":"Air Conditioning","subAmenities":{"type":[]}},
# #         {"amenity":"Air Conditioning","subAmenities":{}},
# #         {"amenity":"Coffee","subAmenities":{}},
# #         {"amenity":"Exercise equipment","subAmenities":{"type":["free weights","workout bench"]}},
# #         {"amenity":"TV", "subAmenities":{"size":"55", "type":"HD", "streamingServices":["Netflix", "Amazon Prime Video", "Disney+"]}},
# #         {"amenity":"Pool", "subAmenities":{"privacy":"Shared", "access":"Community", "features":["Heated", "Lap pool"], "availability":"All year", "hoursOfUse":"9am-10pm", "seasonalAvailability":"Open May to September"}},
# #         {"amenity":"Wifi", "subAmenities":{"quality":"Fast", "speed":"150"}},
# #         {"amenity":"Washer", "subAmenities":{"price":"Free", "location":"In unit"}},
# #         {"amenity":"Free parking on premises", "subAmenities":{"type":"Garage", "numberOfSpaces":1}},
# #         {"amenity":"Dedicated workspace", "subAmenities":{"location":"common area", "setup":["Desk", "Ergonomic chair", "Monitor"]}},
# #         {"amenity":"Indoor fireplace", "subAmenities":{"type":["Gas", "Wood-burning"]}},
# #         {"amenity":"Coffee maker", "subAmenities":{"type":["Drip coffee maker", "Espresso machine", "French press"]}},
# #         {"amenity":"Sound system", "subAmenities":{"brand":"Sonos", "connectivity":["Bluetooth", "Wifi", "Aux"]}},
# #         {"amenity":"Unknown Amenity", "subAmenities":{"type":"Special", "brand":"Acme", "privacy":"Very", "features":["Feature A", "Feature B", "Feature C"], "location":"Everywhere", "price":"Costly", "availability":"Always", "numberOfSpaces":5}},
# #         {"amenity":"Housekeeping", "subAmenities": {"price": "Included with your stay", "availability": ["Monday", "Wednesday", "Friday"], "timeRange": "9:00 am to 5:00 pm"}},
# #         {"amenity":"Housekeeping", "subAmenities": {"price": "Available at extra cost", "frequency": 3, "timeRange": "24 hours"}},
# #         {"amenity":"Housekeeping", "subAmenities": {"price": "$50 per session", "frequency": "Daily", "timeRange": "24 hours"}},
# #         {"amenity":"Housekeeping", "subAmenities": {"availability": ["Saturday", "Sunday"], "timeRange": "10:00 am to 4:00 pm"}},
# #         {"amenity":"Housekeeping", "subAmenities": {"frequency": "Twice a week", "availability": ["Tuesday", "Thursday"]}},
# #         {"amenity":"Housekeeping", "subAmenities": {"frequency": 5}},
# #         {"amenity":"Essentials"}
# #     ]
# #     """
# #
# #     output_list = format_airbnb_amenities_from_json_string(json_input_example)
# #     print("--- Main Example Output ---")
# #     for s in output_list:
# #         print(s)
# #
# #     print("\n--- Another Example: TV with only size ---")
# #     json_input_tv_size_only = """
# #     [
# #         {"amenity":"TV", "subAmenities":{"size":"42"}}
# #     ]
# #     """
# #     output_tv_size_only = format_airbnb_amenities_from_json_string(json_input_tv_size_only)
# #     for s in output_tv_size_only:
# #         print(s)
# #
# #     print("\n--- Example: Default formatter with multiple subAmenities ---")
# #     json_input_default_complex = """
# #     [
# #         {"amenity":"Super Tent", "subAmenities":{"type":"Canvas", "brand":"Nomad", "privacy":"Private", "features":["Waterproof", "Sleeps 4"], "location":"Campsite C", "price":"$20/night", "availability":"Seasonal", "numberOfSpaces":1}}
# #     ]
# #     """
# #     output_default_complex = format_airbnb_amenities_from_json_string(json_input_default_complex)
# #     for s in output_default_complex:
# #         print(s)
#
#
#



import json
import re
import pandas as pd
import numpy as np
import mysql.connector # Added for MySQL connection

# --- Helper for Normalization ---
pattern = re.compile(r"[\s\-:]+") # Precompile regex for efficiency
normalize = lambda x: pattern.sub(" ", x.strip().lower()).lower() if isinstance(x, str) else x

# --- Main Analysis Function ---

def get_top_amenities(df, db_config):
    """
    Analyze top missing amenities by price and revenue impact, using pre-formatted
    amenities from the 'amenities_list' column in the test data source.

    Parameters:
    - df: pandas DataFrame - Main data loaded from SQL database (e.g., rental_properties)
                            Must contain 'amenities', 'price', 'total_revenue' columns.
    - db_config: dict - Database connection configuration for fetching the pre-formatted
                     test amenities list from userdynamiclistset.
                     Example: {'host': 'localhost', 'user': 'root', 'password': '', 'database': 'pricing'}

    Returns:
    - JSON string with top 10 missing amenities by price and revenue impact
    """

    # -------------------- Debug Info --------------------
    print(f"Main DataFrame columns: {df.columns.tolist()}")

    # -------------------- Amenity Processing (Main DataFrame - rental_properties) --------------------
    # This part remains, as we need to extract amenities from the raw source
    def process_main_amenities(s):
        try:
            if pd.isna(s): return set()
            data = json.loads(s) if isinstance(s, str) else s # Handle potential string input
            if isinstance(data, list):
                result = set()
                for group in data:
                    if isinstance(group, dict):
                        items = group.get("items", [])
                        if isinstance(items, list):
                            for item in items:
                                if isinstance(item, dict) and "name" in item:
                                    result.add(normalize(item["name"]))
                return result
            return set()
        except (json.JSONDecodeError, TypeError, Exception) as e:
            # print(f"Warning: Error processing main amenity: {e} - Input: {str(s)[:100]}") # Optional: for debugging
            return set()

    print("Processing main amenities from rental_properties...")
    df["amenities_set"] = df["amenities"].apply(process_main_amenities)
    all_amenities = set().union(*df["amenities_set"].values) if len(df) > 0 and not df["amenities_set"].empty else set()
    print(f"Total unique amenities found in main data: {len(all_amenities)}")

    # -------------------- Amenity Processing (Test Data - userdynamiclistset) --------------------
    # Fetches the PRE-FORMATTED list from the 'amenities_list' column
    test_amenities_list_preformatted = []
    try:
        print(f"Connecting to database for test amenities: {db_config.get('database')} on {db_config.get('host')}")
        conn_test = mysql.connector.connect(**db_config)
        cursor_test = conn_test.cursor(dictionary=True)

        # Fetch the JSON string from the 'amenities_list' column from ONE row
        # Make sure to adjust ORDER BY if 'id' isn't suitable or doesn't exist
        query_test = "SELECT amenities_list FROM userdynamiclistset ORDER BY id LIMIT 1"
        print(f"Executing query for pre-formatted test amenities: {query_test}")
        cursor_test.execute(query_test)
        first_row = cursor_test.fetchone()

        if first_row and 'amenities_list' in first_row and first_row['amenities_list']:
            amenities_list_json_string = first_row['amenities_list']
            try:
                # Parse the JSON string into a Python list
                parsed_list = json.loads(amenities_list_json_string)
                if isinstance(parsed_list, list):
                    # Ensure all items are strings before adding
                    test_amenities_list_preformatted = [str(item) for item in parsed_list if isinstance(item, (str, int, float))]
                    print(f"Successfully parsed 'amenities_list'. Count: {len(test_amenities_list_preformatted)}")
                    if test_amenities_list_preformatted:
                         print(f"First few pre-formatted test amenities: {test_amenities_list_preformatted[:5]}")
                else:
                    print(f"Warning: Parsed 'amenities_list' is not a list (Type: {type(parsed_list)}). String: {amenities_list_json_string[:100]}...")
            except json.JSONDecodeError:
                print(f"Warning: Failed to parse JSON from 'amenities_list'. String: {amenities_list_json_string[:100]}...")
        else:
            print("Warning: No 'amenities_list' data found in the first row of userdynamiclistset or it was empty.")

    except mysql.connector.Error as err:
        print(f"MySQL Error fetching test amenities: {err}")
    except Exception as e:
        print(f"General Error fetching/processing test amenities: {e}")
    finally:
        if 'conn_test' in locals() and conn_test.is_connected():
            cursor_test.close()
            conn_test.close()
            print("Test amenities database connection closed.")

    # Normalize the pre-formatted list to create the test set
    test_amenities = {normalize(amenity) for amenity in test_amenities_list_preformatted}
    print(f"Total unique normalized amenities in test data (from amenities_list): {len(test_amenities)}")

    # -------------------- Missing Amenities Calculation --------------------
    missing_amenities = all_amenities - test_amenities
    print(f"Total missing amenities: {len(missing_amenities)}")
    if not missing_amenities and (all_amenities and test_amenities):
        print("Note: No missing amenities found.")
    elif not all_amenities:
        print("Warning: No amenities processed from the main dataframe.")
    elif not test_amenities:
        print("Warning: No amenities processed from the test data source (userdynamiclistset amenities_list).")

    # -------------------- Impact Calculation (Remains the same) --------------------
    price_impacts = {}
    revenue_impacts = {}

    if not missing_amenities:
        print("Skipping impact calculation as there are no missing amenities to analyze.")
    elif df.empty or 'amenities_set' not in df.columns or df['amenities_set'].apply(len).sum() == 0:
        print("Skipping impact calculation as main dataframe is empty or has no processed amenities.")
    else:
        try:
            # Ensure required columns exist and are numeric
            for col in ["price", "total_revenue"]:
                if col not in df.columns:
                    print(f"Creating missing column in main df: {col} with default 0")
                    df[col] = 0
                df[col] = pd.to_numeric(df[col], errors='coerce').fillna(0)

            print("Exploding amenities for impact calculation...")
            df_with_amenities = df[df['amenities_set'].apply(lambda x: bool(x))]
            if df_with_amenities.empty:
                print("No listings with amenities found in main data. Skipping impact calculation.")
            else:
                exploded = df_with_amenities.explode("amenities_set")[["amenities_set", "price", "total_revenue"]].copy()
                exploded = exploded[exploded["amenities_set"].notna() & (exploded["amenities_set"] != "")]

                if exploded.empty:
                    print("Exploded dataframe is empty. Cannot calculate impact.")
                else:
                    print("Calculating group statistics...")
                    stats = exploded.groupby("amenities_set").agg(
                        price_sum=("price", "sum"),
                        price_count=("price", "count"),
                        revenue_sum=("total_revenue", "sum"),
                        revenue_count=("total_revenue", "count")
                    )

                    # Calculate price impact
                    total_price_main_df = df["price"].sum()
                    total_listings_main_df = len(df)
                    def calculate_price_impact(row):
                        try:
                            if row["price_count"] <= 0 or (total_listings_main_df - row["price_count"]) <= 0: return 0
                            avg_with = row["price_sum"] / row["price_count"]
                            avg_without = (total_price_main_df - row["price_sum"]) / (total_listings_main_df - row["price_count"])
                            if avg_without == 0: return np.nan
                            return ((avg_with - avg_without) / avg_without) * 100
                        except ZeroDivisionError: return np.nan
                        except Exception: return np.nan
                    print("Calculating price impact...")
                    stats["price_impact"] = stats.apply(calculate_price_impact, axis=1)

                    # Calculate revenue impact
                    total_revenue_main_df = df["total_revenue"].sum()
                    def calculate_revenue_impact(row):
                        try:
                            if row["revenue_count"] <= 0 or (total_listings_main_df - row["revenue_count"]) <= 0: return 0
                            avg_with = row["revenue_sum"] / row["revenue_count"]
                            avg_without = (total_revenue_main_df - row["revenue_sum"]) / (total_listings_main_df - row["revenue_count"])
                            if avg_without == 0: return np.nan
                            return ((avg_with - avg_without) / avg_without) * 100
                        except ZeroDivisionError: return np.nan
                        except Exception: return np.nan
                    print("Calculating revenue impact...")
                    stats["revenue_impact"] = stats.apply(calculate_revenue_impact, axis=1)

                    # Filter and Sort Results
                    def get_top_amenities_list(impact_series, n=10):
                        filtered_impact = impact_series[impact_series.index.isin(missing_amenities)]
                        return (
                            filtered_impact.replace([np.inf, -np.inf], np.nan)
                            .dropna()
                            .sort_values(ascending=False)
                            .head(n)
                            .to_dict()
                        )
                    print("Finding top amenities...")
                    price_impacts = get_top_amenities_list(stats["price_impact"])
                    revenue_impacts = get_top_amenities_list(stats["revenue_impact"])
        except Exception as e:
            print(f"Error during impact calculation: {e}")
            import traceback
            traceback.print_exc()

    print("Generating final JSON response...")
    return json.dumps({
        "top_10_missing_by_price": {k: f"{v:.2f}%" for k, v in price_impacts.items()},
        "top_10_missing_by_revenue": {k: f"{v:.2f}%" for k, v in revenue_impacts.items()}
    }, indent=2, ensure_ascii=False)


# --- Example Usage ---
# if __name__ == '__main__':
#     # Database Configuration
#     db_config_main = {
#         'host': '127.0.0.1',
#         'user': 'root',
#         'password': '',  # Add your password if needed
#         'database': 'pricing'
#     }
#     # Assuming userdynamiclistset is in the same database
#     db_config_test = db_config_main
#
#     # Fetch Main Data (rental_properties)
#     df_main = pd.DataFrame()
#     try:
#         print("Connecting to main database...")
#         connection_main = mysql.connector.connect(**db_config_main)
#         # Select only necessary columns to reduce memory usage
#         query_main = "SELECT id, amenities, price, total_revenue FROM rental_properties"
#         print(f"Executing main data query: {query_main}")
#         df_main = pd.read_sql_query(query_main, connection_main)
#         print(f"Fetched {len(df_main)} rows for main data.")
#     except mysql.connector.Error as err:
#         print(f"MySQL Error fetching main data: {err}")
#     except Exception as e:
#         print(f"General error fetching main data: {e}")
#     finally:
#         if 'connection_main' in locals() and connection_main.is_connected():
#             connection_main.close()
#             print("Main database connection closed.")
#
#     # Run analysis if data was fetched
#     if not df_main.empty:
#         result_json = get_top_amenities(df_main.copy(), db_config_test)
#         print("\n--- Analysis Result ---")
#         print(result_json)
#     else:
#         print("Could not fetch main data, skipping analysis.")