

import pandas as pd
import json
from datetime import datetime


# # Load data
# df = pd.read_csv("21Mar-23Mar_350.csv")
# test = pd.read_csv("processed_test.csv")
#
# # Ensure amenities are stored as lists
# df["amenities_list"] = df["amenities_list"].apply(lambda x: eval(x) if isinstance(x, str) else x)
# test_amenities = eval(test["amenities_list"].iloc[0]) if isinstance(test["amenities_list"].iloc[0], str) else \
# test["amenities_list"].iloc[0]
#
#
# # Precompute amenity impacts (case-insensitive)
# def compute_amenity_impact_percentage(df, amenities):
#     impacts = {}
#     for amenity in amenities:
#         with_amenity = df[df["amenities_list"].apply(lambda x: amenity in x)]["price"]
#         without_amenity = df[df["amenities_list"].apply(lambda x: amenity not in x)]["price"]
#         if not without_amenity.empty and without_amenity.mean() != 0:
#             percent_change = ((with_amenity.mean() - without_amenity.mean()) / without_amenity.mean()) * 100
#         else:
#             percent_change = 0
#         impacts[amenity.lower()] = round(percent_change, 2)
#     return impacts
#
#
# all_amenities = list(set(amenity.lower() for sublist in df["amenities_list"] for amenity in sublist))
# amenity_impact_dict = compute_amenity_impact_percentage(df, all_amenities)
#
# # Precompute feature price averages (for beds, bedrooms, bathrooms, guests)
# feature_price_means = {}
# for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#     feature_price_means[col] = df.groupby(col)["price"].mean().to_dict()
#
# # Convert test amenities to lowercase for case-insensitive matching
# test_amenities_lower = {amenity.lower() for amenity in test_amenities}
#
# # Compute amenities_score (weighted sum of matched amenities)
# df["amenities_score"] = df["amenities_list"].apply(
#     lambda x: sum(
#         amenity_impact_dict.get(amenity.lower(), 0) for amenity in x if amenity.lower() in test_amenities_lower)
# )
#
#
# # Compute feature_score (price difference for features)
# def compute_feature_score(row):
#     score = 0
#     for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#         from_value = row[col]
#         to_value = test[col].iloc[0]
#         from_price = feature_price_means[col].get(from_value, 0)
#         to_price = feature_price_means[col].get(to_value, 0)
#         score += (to_price - from_price)  # Price impact of matching test's feature
#     return score
#
#
# df["feature_score"] = df.apply(compute_feature_score, axis=1)
#
# # Total match score
# df["total_match_score"] = df["amenities_score"] + df["feature_score"]
#
# # Get entry with highest weighted score
# best_match = df.loc[df["total_match_score"].idxmax()]
# print("Best Match:", best_match)
#
# # Non-matched amenities in the best match
# non_matched_amenities = [
#     amenity for amenity in best_match["amenities_list"]
#     if amenity.lower() not in test_amenities_lower
# ]
#
# # Price adjustments for non-matched amenities
# non_matched_impact = sum(amenity_impact_dict.get(amenity.lower(), 0) for amenity in non_matched_amenities)
#
# # Price adjustments for feature differences
# adjustments = {}
# for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#     from_value = best_match[col]
#     to_value = test[col].iloc[0]
#     if from_value != to_value:
#         from_price = feature_price_means[col].get(from_value, 0)
#         to_price = feature_price_means[col].get(to_value, 0)
#         adjustments[col] = to_price - from_price
#
# print(f"\nTotal Price Impact of Non-Matched Amenities: {non_matched_impact:.2f}%")
# print("Price Adjustments for Feature Differences:", adjustments)
#
#
#
#
#
# # Calculate recommended price based on the new instructions
# best_price = best_match['price']
#
# # Compute adjusted price based on amenities impact
# if non_matched_impact < 100:
#     amenity_adj_price = best_price * (1 + non_matched_impact / 100)
# else:
#     amenity_adj_price = best_price * (non_matched_impact / 100)
#
# # Collect all adjusted prices
# adjusted_prices = [amenity_adj_price]  # Start with amenities-adjusted price
#
# # Add feature-adjusted prices (best_price + individual feature adjustment)
# for adj_value in adjustments.values():
#     adjusted_prices.append(best_price + adj_value)
#
# # Calculate final recommended price as average of all adjusted prices
# recommended_price = sum(adjusted_prices) / len(adjusted_prices)
#
# print(f"\nRecommended Price: ${recommended_price:.2f}")





### ---- this was important below


# import pandas as pd
#
# def get_recommended_price(df: pd.DataFrame, test: pd.DataFrame) -> float:
#     # Ensure amenities are stored as lists
#     df["amenities_list"] = df["amenities_list"].apply(lambda x: eval(x) if isinstance(x, str) else x)
#     test_amenities = eval(test["amenities_list"].iloc[0]) if isinstance(test["amenities_list"].iloc[0], str) else test["amenities_list"].iloc[0]
#
#     # Precompute amenity impacts (case-insensitive)
#     def compute_amenity_impact_percentage(df, amenities):
#         impacts = {}
#         for amenity in amenities:
#             with_amenity = df[df["amenities_list"].apply(lambda x: amenity in x)]["price"]
#             without_amenity = df[df["amenities_list"].apply(lambda x: amenity not in x)]["price"]
#             if not without_amenity.empty and without_amenity.mean() != 0:
#                 percent_change = ((with_amenity.mean() - without_amenity.mean()) / without_amenity.mean()) * 100
#             else:
#                 percent_change = 0
#             impacts[amenity.lower()] = round(percent_change, 2)
#         return impacts
#
#     # Compute all unique amenities (in lowercase)
#     all_amenities = list(set(amenity.lower() for sublist in df["amenities_list"] for amenity in sublist))
#     amenity_impact_dict = compute_amenity_impact_percentage(df, all_amenities)
#
#     # Precompute feature price averages (for beds, bedrooms, bathrooms, guests)
#     feature_price_means = {}
#     for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#         feature_price_means[col] = df.groupby(col)["price"].mean().to_dict()
#
#     # Convert test amenities to lowercase for case-insensitive matching
#     test_amenities_lower = {amenity.lower() for amenity in test_amenities}
#
#     # Compute amenities_score (weighted sum of matched amenities)
#     df["amenities_score"] = df["amenities_list"].apply(
#         lambda x: sum(
#             amenity_impact_dict.get(amenity.lower(), 0)
#             for amenity in x
#             if amenity.lower() in test_amenities_lower
#         )
#     )
#
#     # Compute feature_score (price difference for features)
#     def compute_feature_score(row):
#         score = 0
#         for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#             from_value = row[col]
#             to_value = test[col].iloc[0]
#             from_price = feature_price_means[col].get(from_value, 0)
#             to_price = feature_price_means[col].get(to_value, 0)
#             score += (to_price - from_price)  # Price impact of matching test's feature
#         return score
#
#     df["feature_score"] = df.apply(compute_feature_score, axis=1)
#
#     # Total match score
#     df["total_match_score"] = df["amenities_score"] + df["feature_score"]
#
#     # Get entry with highest weighted score
#     best_match = df.loc[df["total_match_score"].idxmax()]
#     print(best_match['price'])
#
#     # Identify non-matched amenities in the best match
#     non_matched_amenities = [
#         amenity for amenity in best_match["amenities_list"]
#         if amenity.lower() not in test_amenities_lower
#     ]
#
#     # Price adjustments for non-matched amenities
#     non_matched_impact = sum(amenity_impact_dict.get(amenity.lower(), 0) for amenity in non_matched_amenities)
#
#     # Price adjustments for feature differences
#     adjustments = {}
#     for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#         from_value = best_match[col]
#         to_value = test[col].iloc[0]
#         if from_value != to_value:
#             from_price = feature_price_means[col].get(from_value, 0)
#             to_price = feature_price_means[col].get(to_value, 0)
#             adjustments[col] = to_price - from_price
#
#     # Calculate recommended price based on the instructions
#     best_price = best_match['price']
#
#     # Compute adjusted price based on amenities impact
#     if non_matched_impact < 100:
#         amenity_adj_price = best_price * (1 + non_matched_impact / 100)
#     else:
#         amenity_adj_price = best_price * (non_matched_impact / 100)
#
#     # Collect all adjusted prices
#     adjusted_prices = [amenity_adj_price]  # Start with amenities-adjusted price
#     # Add feature-adjusted prices (best_price + individual feature adjustment)
#     for adj_value in adjustments.values():
#         print("adjusted prices: " + str(adj_value))
#         adjusted_prices.append(best_price + adj_value)
#
#     # Calculate final recommended price as the average of all adjusted prices
#     recommended_price = sum(adjusted_prices) / len(adjusted_prices)
#     print(recommended_price)
#
#     return recommended_price
# #
#
# ## /////////////////// this was imp above
#
#
# df = pd.read_csv("21Mar-23Mar_350.csv")
# test = pd.read_csv("processed_test.csv")
#
# price = get_recommended_price(df, test)
# print("Recommended Price:", price)


########################################################################################################################

#
# ### occupnacy based adjustments
#
# import pandas as pd
#
# # Define discount rules for each type
# discount_rules = {
#     "default": {
#         "0_15_days": {
#             "≤10": -15,
#             "≤20": -15,
#             "≤30": -10,
#             "≤40": -5,
#             "≤50": -5,
#             "≤60": 0,
#             "≤70": 0,
#             "≤80": 0,
#             "≤100": 0
#         },
#         "16_30_days": {
#             "≤10": -10,
#             "≤20": -10,
#             "≤30": -5,
#             "≤40": -5,
#             "≤50": 0,
#             "≤60": 0,
#             "≤70": 0,
#             "≤80": 5,
#             "≤100": 10
#         },
#         "30_60_days": {
#             "≤10": -5,
#             "≤20": -5,
#             "≤30": -5,
#             "≤40": 0,
#             "≤50": 0,
#             "≤60": 0,
#             "≤70": 5,
#             "≤80": 10,
#             "≤100": 15
#         },
#         "60_90_days": {
#             "≤10": -5,
#             "≤20": -5,
#             "≤30": 0,
#             "≤40": 0,
#             "≤50": 0,
#             "≤60": 5,
#             "≤70": 10,
#             "≤80": 15,
#             "≤100": 20
#         }
#     },
#     "aggressive": {
#         "0_15_days": {
#             "≤10": -30,
#             "≤20": -25,
#             "≤30": -20,
#             "≤40": -20,
#             "≤50": -5,
#             "≤60": 10,
#             "≤70": 5,
#             "≤80": 5,
#             "≤100": 0
#         },
#         "16_30_days": {
#             "≤10": -20,
#             "≤20": -20,
#             "≤30": -15,
#             "≤40": -10,
#             "≤50": -10,
#             "≤60": -5,
#             "≤70": 0,
#             "≤80": 0,
#             "≤100": 0
#         },
#         "30_60_days": {
#             "≤10": -15,
#             "≤20": -10,
#             "≤30": -10,
#             "≤40": -5,
#             "≤50": 0,
#             "≤60": 0,
#             "≤70": 0,
#             "≤80": 0,
#             "≤100": 5
#         },
#         "60_90_days": {
#             "≤10": -10,
#             "≤20": -5,
#             "≤30": -5,
#             "≤40": -5,
#             "≤50": 0,
#             "≤60": 0,
#             "≤70": 0,
#             "≤80": 5,
#             "≤100": 5
#         }
#     },
#
#     "step_last_minute": {
#         "0_15_days": {
#             "≤10": -35,
#             "≤20": -35,
#             "≤30": -30,
#             "≤40": -25,
#             "≤50": -20,
#             "≤60": -15,
#             "≤70": -10,
#             "≤80": -5,
#             "≤100": 0
#         },
#         "16_30_days": {
#             "≤10": -30,
#             "≤20": -25,
#             "≤30": -20,
#             "≤40": -15,
#             "≤50": -10,
#             "≤60": -5,
#             "≤70": 0,
#             "≤80": 5,
#             "≤100": 5
#         },
#         "30_60_days": {
#             "≤10": -25,
#             "≤20": -20,
#             "≤30": -15,
#             "≤40": -10,
#             "≤50": -5,
#             "≤60": 0,
#             "≤70": 0,
#             "≤80": 0,
#             "≤100": 0
#         },
#         "60_90_days": {
#             "≤10": 0,
#             "≤20": 0,
#             "≤30": 0,
#             "≤40": 0,
#             "≤50": 0,
#             "≤60": 0,
#             "≤70": 0,
#             "≤80": 0,
#             "≤100": 0
#         }
#     }
#
# }
#
#
# # Function to get the discount percentage based on occupancy
# def get_discount(occupancy, range_key, discount_rule_type):
#     rules = discount_rules[discount_rule_type][range_key]
#     if occupancy <= 10:
#         return rules["≤10"]
#     elif occupancy <= 20:
#         return rules["≤20"]
#     elif occupancy <= 30:
#         return rules["≤30"]
#     elif occupancy <= 40:
#         return rules["≤40"]
#     elif occupancy <= 50:
#         return rules["≤50"]
#     elif occupancy <= 60:
#         return rules["≤60"]
#     elif occupancy <= 70:
#         return rules["≤70"]
#     elif occupancy <= 80:
#         return rules["≤80"]
#     else:
#         return rules["≤100"]
#
#
# # Function to calculate adjusted price
# def calculate_adjusted_price(row, base_price, discount_rule_type):
#     # Get discounts for each range
#     discount_0_15 = get_discount(row["occupancy_0_15_days"], "0_15_days", discount_rule_type)
#     discount_16_30 = get_discount(row["occupancy_16_30_days"], "16_30_days", discount_rule_type)
#     discount_30_60 = get_discount(row["occupancy_30_60_days"], "30_60_days", discount_rule_type)
#     discount_60_90 = get_discount(row["occupancy_60_90_days"], "60_90_days", discount_rule_type)
#
#     # Apply discounts to the base price
#     adjusted_price_0_15 = base_price * (1 + discount_0_15 / 100)
#     adjusted_price_16_30 = base_price * (1 + discount_16_30 / 100)
#     adjusted_price_30_60 = base_price * (1 + discount_30_60 / 100)
#     adjusted_price_60_90 = base_price * (1 + discount_60_90 / 100)
#
#     # Return the adjusted prices
#     return pd.Series({
#         "adjusted_price_0_15": adjusted_price_0_15,
#         "adjusted_price_16_30": adjusted_price_16_30,
#         "adjusted_price_30_60": adjusted_price_30_60,
#         "adjusted_price_60_90": adjusted_price_60_90
#     })
#
#
# # Example usage
# # Assuming df is your DataFrame and base_price is the original price
# base_price = 500  # Example base price
# discount_rule_type = "default"  # Choose from "default", "aggressive", "step_last_minute"
#
# # Apply the function to the DataFrame
# adjusted_prices = test.apply(calculate_adjusted_price, axis=1, base_price=base_price,
#                            discount_rule_type=discount_rule_type)
#
# # Merge the adjusted prices back into the original DataFrame
# test = pd.concat([test, adjusted_prices], axis=1)
#
# # Display the DataFrame with adjusted prices
# print(test[["occupancy_0_15_days", "occupancy_16_30_days", "occupancy_30_60_days", "occupancy_60_90_days",
#           "adjusted_price_0_15", "adjusted_price_16_30", "adjusted_price_30_60", "adjusted_price_60_90"]])
#
#
# #######################################################################################################################
#
#
# imp above
#
#
#
#
#
#
#
#
#
# # Load the booking window stays improved CSV
# booking_window_df = pd.read_csv("booking_window_stays_improved.csv", index_col=0)
#
#
# # Get the list of months dynamically from booking_window_stays_improved.csv
# month_columns = booking_window_df.columns.tolist()
#
# # Sort the months correctly based on datetime
# month_columns = sorted(month_columns, key=lambda x: datetime.strptime(x, "%b_%Y"))
#
# # Extract occupancy values dynamically for all months
# occupancy_data = {month: test[month].values[0] for month in month_columns}
#
# # Initialize recommendations
# recommendations = {}
#
# # Check if either current or next month has <40% occupancy
# current_month_occupancy = occupancy_data[month_columns[0]]
# next_month_occupancy = occupancy_data[month_columns[1]]
#
# low_occupancy_flag = current_month_occupancy < 40 or next_month_occupancy < 40
#
# for i, month in enumerate(month_columns):
#     if low_occupancy_flag and i <= 1:
#         # If current or next month has low occupancy, set 1-night min stay
#         recommendations[month] = {"weekday_min_stay": 1, "weekend_min_stay": 1}
#     else:
#         # Get top 3 stays based on values for the month
#         top_3_stays = booking_window_df[month].nlargest(3)
#
#         # Find the minimum stay from the top 3
#         min_stay = min(int(top_3_stays.index[0].split("_")[0]),
#                        int(top_3_stays.index[1].split("_")[0]),
#                        int(top_3_stays.index[2].split("_")[0]))
#
#         recommendations[month] = {"weekday_min_stay": min_stay, "weekend_min_stay": min_stay}
#
# # Convert to JSON
# recommendations_json = json.dumps(recommendations, indent=4)
# print(recommendations_json)
#
#
#
#
#
# #################################### imp replpaced
#

def get_recommended_price(df: pd.DataFrame, test: pd.DataFrame) -> float:
    """
    Calculate recommended price based on property features and amenities

    Parameters:
    -----------
    df : DataFrame
        Reference properties with price data
    test : DataFrame
        Single property for which to calculate the recommended price

    Returns:
    --------
    float : Recommended price
    """
    try:
        # Check for empty dataframes
        if df.empty or test.empty:
            print("Empty dataframe provided")
            return 0.0

        # Make copies to avoid modifying original dataframes
        df = df.copy()
        test = test.copy()

        # --- STEP 1: Process amenities lists ---
        print("Processing amenities lists...")

        # Function to safely convert amenities to list format
        def safe_convert_amenities(amenities_val):
            """Convert various amenities formats to a list of strings"""
            try:
                if pd.isna(amenities_val):
                    return []

                if isinstance(amenities_val, list):
                    return [str(item).lower() for item in amenities_val]

                if isinstance(amenities_val, str):
                    try:
                        # Try to evaluate as Python literal
                        result = eval(amenities_val)
                        if isinstance(result, list):
                            return [str(item).lower() for item in result]
                    except:
                        # If eval fails, return as single item
                        return [amenities_val.lower()]

                # Default fallback
                return []
            except Exception as e:
                print(f"Error in safe_convert_amenities: {e}")
                return []

        # Process amenities in main dataframe
        if "amenities_list" in df.columns:
            df["processed_amenities"] = df["amenities_list"].apply(safe_convert_amenities)
        else:
            print("Warning: 'amenities_list' column not found in main dataframe")
            df["processed_amenities"] = [[]]

        # Process amenities in test dataframe (single property)
        if "amenities_list" in test.columns:
            test_amenities = safe_convert_amenities(test["amenities_list"].iloc[0])
        else:
            print("Warning: 'amenities_list' column not found in test dataframe")
            test_amenities = []

        print(f"Test property has {len(test_amenities)} amenities")

        # --- STEP 2: Calculate amenity impacts ---
        print("Calculating amenity impacts...")

        # Get all unique amenities
        all_amenities = set()
        for amenity_list in df["processed_amenities"]:
            try:
                all_amenities.update(amenity_list)
            except Exception as e:
                print(f"Error updating all_amenities: {e}")
                print(f"Type of amenity_list: {type(amenity_list)}")

        print(f"Found {len(all_amenities)} unique amenities")

        # Calculate price impact for each amenity
        amenity_impacts = {}
        for amenity in all_amenities:
            # Create masks for properties with and without this amenity
            try:
                has_amenity = df["processed_amenities"].apply(lambda x: amenity in x)
            except Exception as e:
                print(f"Error checking amenity: {e}")
                print(f"Amenity: {amenity}, Type: {type(amenity)}")
                continue

            # Calculate price impact if we have enough data
            if has_amenity.sum() > 0 and (~has_amenity).sum() > 0:
                avg_price_with = df.loc[has_amenity, "price"].mean()
                avg_price_without = df.loc[~has_amenity, "price"].mean()

                if avg_price_without > 0:  # Avoid division by zero
                    impact = ((avg_price_with - avg_price_without) / avg_price_without) * 100
                    amenity_impacts[amenity] = round(impact, 2)
                else:
                    amenity_impacts[amenity] = 0
            else:
                amenity_impacts[amenity] = 0

        # --- STEP 3: Calculate feature price averages ---
        print("Calculating feature price averages...")

        feature_price_means = {}
        for col in ["beds", "bedrooms", "bathrooms", "guests"]:
            if col in df.columns:
                feature_price_means[col] = df.groupby(col)["price"].mean().to_dict()
            else:
                print(f"Warning: '{col}' column not found in main dataframe")
                feature_price_means[col] = {}

        # --- STEP 4: Calculate amenity match scores ---
        print("Calculating amenity match scores...")

        def calc_amenity_score(property_amenities):
            """Calculate weighted score for matching amenities"""
            try:
                score = 0
                for amenity in property_amenities:
                    if amenity in test_amenities:
                        score += amenity_impacts.get(amenity, 0)
                return score
            except Exception as e:
                print(f"Error in calc_amenity_score: {e}")
                print(f"property_amenities type: {type(property_amenities)}")
                return 0

        df["amenity_score"] = df["processed_amenities"].apply(calc_amenity_score)

        # --- STEP 5: Calculate feature match scores ---
        print("Calculating feature match scores...")

        def calc_feature_score(row):
            """Calculate feature price differences"""
            try:
                score = 0
                for col in ["beds", "bedrooms", "bathrooms", "guests"]:
                    if col not in df.columns or col not in test.columns:
                        continue

                    from_val = row[col]
                    to_val = test[col].iloc[0]

                    # For each property, make sure values are scalar
                    if isinstance(from_val, pd.Series):
                        from_val = from_val.iloc[0]
                    if isinstance(to_val, pd.Series):
                        to_val = to_val.iloc[0]

                    from_price = feature_price_means.get(col, {}).get(from_val, 0)
                    to_price = feature_price_means.get(col, {}).get(to_val, 0)

                    score += (to_price - from_price)
                return score
            except Exception as e:
                print(f"Error in calc_feature_score: {e}")
                return 0

        df["feature_score"] = df.apply(calc_feature_score, axis=1)

        # --- STEP 6: Find best matching property ---
        print("Finding best match...")

        df["total_score"] = df["amenity_score"] + df["feature_score"]

        if df.empty:
            print("Error: No properties found for comparison")
            return 0.0

        # Modified: Find the best match in a more robust way
        # Sort by total score and take the first row
        df_sorted = df.sort_values("total_score", ascending=False)
        if df_sorted.empty:
            print("Error: No properties found after sorting")
            return 0.0

        best_match = df_sorted.iloc[0]

        # Get the price from the best match
        best_price = best_match["price"]
        if isinstance(best_price, pd.Series):
            best_price = best_price.iloc[0]

        print(f"Best match found with price: {best_price}")
        print(f"Best match amenities count: {len(best_match['processed_amenities'])}")

        # --- STEP 7: Calculate price adjustments ---
        print("Calculating price adjustments...")

        # Calculate adjustments based on missing and extra amenities
        test_amenities_set = set(test_amenities)
        best_amenities_set = set(best_match["processed_amenities"])

        # Calculate missing and extra amenities
        missing_amenities = best_amenities_set - test_amenities_set
        extra_amenities = test_amenities_set - best_amenities_set

        print(f"Missing amenities: {len(missing_amenities)}")
        print(f"Extra amenities: {len(extra_amenities)}")

        # Calculate impact of missing and extra amenities
        missing_impact = sum(amenity_impacts.get(amenity, 0) for amenity in missing_amenities)
        extra_impact = sum(amenity_impacts.get(amenity, 0) for amenity in extra_amenities)

        # Following the commented-out code's approach for net impact
        net_amenity_impact = extra_impact - missing_impact

        # Calculate feature adjustments
        feature_adjustments = {}
        for col in ["beds", "bedrooms", "bathrooms", "guests"]:
            if col not in df.columns or col not in test.columns:
                continue

            best_val = best_match[col]
            test_val = test[col].iloc[0]

            # Handle Series values
            if isinstance(best_val, pd.Series):
                best_val = best_val.iloc[0]
            if isinstance(test_val, pd.Series):
                test_val = test_val.iloc[0]

            if best_val != test_val:
                best_price_avg = feature_price_means.get(col, {}).get(best_val, 0)
                test_price_avg = feature_price_means.get(col, {}).get(test_val, 0)
                feature_adjustments[col] = test_price_avg - best_price_avg

        # --- STEP 8: Calculate final recommended price ---
        print("Calculating final price...")

        # Use the logic from the commented-out code for amenity adjustment
        if abs(net_amenity_impact) < 100:
            amenity_adj_price = best_price * (1 + net_amenity_impact / 100)
        else:
            # If impact is excessive, use the impact directly (like in commented code)
            if net_amenity_impact > 0:
                amenity_adj_price = best_price * (1 + net_amenity_impact / 100)
            else:
                # Cap negative impact to avoid prices dropping too much
                amenity_adj_price = best_price * 0.5

        # Collect all adjusted prices
        adjusted_prices = [amenity_adj_price]

        # Add feature adjustments
        for adj in feature_adjustments.values():
            adjusted_prices.append(best_price + adj)

        # Calculate average of all adjustments
        if adjusted_prices:
            recommended_price = sum(adjusted_prices) / len(adjusted_prices)
        else:
            recommended_price = best_price

        print(f"Recommended price: {recommended_price}")
        return recommended_price

    except Exception as e:
        print(f"Unexpected error in get_recommended_price: {e}")
        import traceback
        traceback.print_exc()
        return 0.0