# import pandas as pd
# import mysql.connector
# import json  # If needed by process_dataframe or get_recommended_price
# from filter200 import process_dataframe
#
# # --- Import your custom functions ---
# # Assuming filter200.py is in the same directory or accessible in PYTHONPATH
# try:
#     from filter200 import process_dataframe
# except ImportError:
#     print("Error: Could not import process_dataframe from filter200.py.")
#     print("Make sure filter200.py is in the same directory or in your PYTHONPATH.")
#
#
#     # Define a placeholder if you want the script to run for testing other parts
#     def process_dataframe(df, lat, long):
#         print(f"Placeholder process_dataframe called with lat={lat}, long={long}. Returning original df.")
#         return df  # Placeholder returns original df
#
#
# # --- Paste or import your get_recommended_price function here ---
# # (The one you provided in the previous message)
# def get_recommended_price(df: pd.DataFrame, test: pd.DataFrame) -> float:
#     """
#     Calculate recommended price based on property features and amenities
#
#     Parameters:
#     -----------
#     df : DataFrame
#         Reference properties with price data
#     test : DataFrame
#         Single property for which to calculate the recommended price
#
#     Returns:
#     --------
#     float : Recommended price
#     """
#     try:
#         # Check for empty dataframes
#         if df.empty or test.empty:
#             print("Empty dataframe provided to get_recommended_price")
#             return 0.0
#
#         # Make copies to avoid modifying original dataframes
#         df = df.copy()
#         test = test.copy()
#
#         # --- STEP 1: Process amenities lists ---
#         print("Processing amenities lists...")
#
#         # Function to safely convert amenities to list format
#         def safe_convert_amenities(amenities_val):
#             """Convert various amenities formats to a list of strings"""
#             try:
#                 if pd.isna(amenities_val):
#                     return []
#
#                 if isinstance(amenities_val, list):
#                     return [str(item).lower() for item in amenities_val]
#
#                 if isinstance(amenities_val, str):
#                     try:
#                         # Try to evaluate as Python literal
#                         # Using json.loads is generally safer than eval for stringified lists/dicts
#                         result = json.loads(amenities_val)  # Changed from eval to json.loads
#                         if isinstance(result, list):
#                             return [str(item).lower() for item in result]
#                     except (json.JSONDecodeError, TypeError):  # Catch TypeError if not string
#                         # If json.loads fails, treat as a single item list if it's a simple string
#                         # or split if it looks like a comma-separated string without brackets
#                         if '[' not in amenities_val and ']' not in amenities_val and ',' in amenities_val:
#                             return [item.strip().lower() for item in amenities_val.split(',')]
#                         return [amenities_val.lower()]
#
#                 # Default fallback
#                 return []
#             except Exception as e:
#                 print(f"Error in safe_convert_amenities for value '{amenities_val}': {e}")
#                 return []
#
#         # Process amenities in main dataframe
#         if "amenities_list" in df.columns:
#             df["processed_amenities"] = df["amenities_list"].apply(safe_convert_amenities)
#         elif "amenities" in df.columns:  # Fallback to 'amenities' if 'amenities_list' not present
#             print("Warning: 'amenities_list' column not found in main dataframe, trying 'amenities'.")
#             df["processed_amenities"] = df["amenities"].apply(safe_convert_amenities)
#         else:
#             print("Warning: Neither 'amenities_list' nor 'amenities' column found in main dataframe.")
#             df["processed_amenities"] = pd.Series([[] for _ in range(len(df))], index=df.index)
#
#         # Process amenities in test dataframe (single property)
#         # Ensure test dataframe has an 'amenities_list' or 'amenities' column
#         test_amenities_col_name = None
#         if "amenities_list" in test.columns:
#             test_amenities_col_name = "amenities_list"
#         elif "amenities" in test.columns:
#             test_amenities_col_name = "amenities"
#
#         if test_amenities_col_name:
#             test_amenities = safe_convert_amenities(test[test_amenities_col_name].iloc[0])
#         else:
#             print("Warning: Neither 'amenities_list' nor 'amenities' column not found in test dataframe.")
#             test_amenities = []
#
#         print(f"Test property has {len(test_amenities)} amenities: {test_amenities[:5]}...")  # Print first 5
#
#         # --- STEP 2: Calculate amenity impacts ---
#         print("Calculating amenity impacts...")
#
#         all_amenities = set()
#         for amenity_list in df["processed_amenities"]:
#             try:
#                 if isinstance(amenity_list, list):  # Ensure it's a list before updating
#                     all_amenities.update(amenity_list)
#             except Exception as e:
#                 print(f"Error updating all_amenities: {e}")
#                 print(f"Problematic amenity_list: {amenity_list}, Type: {type(amenity_list)}")
#
#         print(f"Found {len(all_amenities)} unique amenities in main df")
#
#         amenity_impacts = {}
#         if "price" not in df.columns:
#             print("Error: 'price' column missing from main dataframe. Cannot calculate amenity impacts.")
#         else:
#             df["price"] = pd.to_numeric(df["price"], errors='coerce').fillna(0)  # Ensure price is numeric
#             for amenity in all_amenities:
#                 try:
#                     has_amenity = df["processed_amenities"].apply(lambda x: isinstance(x, list) and amenity in x)
#                 except Exception as e:
#                     print(f"Error checking amenity presence for '{amenity}': {e}")
#                     continue
#
#                 if has_amenity.sum() > 0 and (~has_amenity).sum() > 0:
#                     avg_price_with = df.loc[has_amenity, "price"].mean()
#                     avg_price_without = df.loc[~has_amenity, "price"].mean()
#
#                     if pd.notna(avg_price_with) and pd.notna(avg_price_without) and avg_price_without > 0:
#                         impact = ((avg_price_with - avg_price_without) / avg_price_without) * 100
#                         amenity_impacts[amenity] = round(impact, 2)
#                     else:
#                         amenity_impacts[amenity] = 0
#                 else:
#                     amenity_impacts[amenity] = 0
#         print(f"Calculated impacts for {len(amenity_impacts)} amenities.")
#
#         # --- STEP 3: Calculate feature price averages ---
#         print("Calculating feature price averages...")
#         feature_price_means = {}
#         if "price" in df.columns:
#             for col in ["beds", "bedrooms", "bathrooms", "guests"]:  # Assuming these are the feature columns
#                 if col in df.columns:
#                     # Ensure feature column is numeric before groupby, handle potential errors
#                     df[col] = pd.to_numeric(df[col], errors='coerce')
#                     valid_rows = df.dropna(subset=[col, "price"])  # Use only rows with valid feature and price
#                     if not valid_rows.empty:
#                         feature_price_means[col] = valid_rows.groupby(col)["price"].mean().to_dict()
#                     else:
#                         feature_price_means[col] = {}
#                 else:
#                     print(f"Warning: Feature column '{col}' not found in main dataframe.")
#                     feature_price_means[col] = {}
#         else:
#             print("Skipping feature price averages as 'price' column is missing.")
#
#         # --- STEP 4: Calculate amenity match scores ---
#         print("Calculating amenity match scores for main df...")
#
#         def calc_amenity_score(property_amenities_list):
#             try:
#                 if not isinstance(property_amenities_list, list):  # Ensure it's a list
#                     return 0
#                 score = 0
#                 for amenity in property_amenities_list:
#                     if amenity in test_amenities:  # test_amenities is already a list of strings
#                         score += amenity_impacts.get(amenity, 0)
#                 return score
#             except Exception as e:
#                 print(f"Error in calc_amenity_score: {e}")
#                 return 0
#
#         df["amenity_score"] = df["processed_amenities"].apply(calc_amenity_score)
#
#         # --- STEP 5: Calculate feature match scores ---
#         print("Calculating feature match scores for main df...")
#
#         def calc_feature_score(row):
#             try:
#                 score = 0
#                 # Ensure test dataframe has the feature columns
#                 test_features_present = all(
#                     f_col in test.columns for f_col in ["beds", "bedrooms", "bathrooms", "guests"])
#                 if not test_features_present:
#                     # print("Warning: Not all required feature columns present in test dataframe for feature scoring.")
#                     return 0  # Or handle differently
#
#                 for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#                     if col not in df.columns or col not in test.columns:
#                         continue
#
#                     from_val = row[col]
#                     to_val = test[col].iloc[0]  # test is a single row DataFrame
#
#                     # Convert to numeric, coercing errors. This handles non-numeric values gracefully.
#                     from_val_numeric = pd.to_numeric(from_val, errors='coerce')
#                     to_val_numeric = pd.to_numeric(to_val, errors='coerce')
#
#                     if pd.isna(from_val_numeric) or pd.isna(to_val_numeric):
#                         # print(f"Warning: Non-numeric or NaN feature value for {col}. from: {from_val}, to: {to_val}")
#                         continue  # Skip if values are not comparable as numbers
#
#                     from_price = feature_price_means.get(col, {}).get(from_val_numeric, 0)
#                     to_price = feature_price_means.get(col, {}).get(to_val_numeric, 0)
#                     score += (to_price - from_price)
#                 return score
#             except Exception as e:
#                 print(f"Error in calc_feature_score for row: {e}")
#                 return 0
#
#         df["feature_score"] = df.apply(calc_feature_score, axis=1)
#
#         # --- STEP 6: Find best matching property ---
#         print("Finding best match...")
#         df["total_score"] = df["amenity_score"] + df["feature_score"]
#
#         if df.empty or df["total_score"].isna().all():  # Check if all scores are NaN
#             print("Error: No properties found for comparison or all scores are NaN.")
#             return 0.0
#
#         df_sorted = df.sort_values("total_score", ascending=False, na_position='last')  # Put NaNs at the end
#         if df_sorted.empty:
#             print("Error: No properties found after sorting.")
#             return 0.0
#
#         best_match = df_sorted.iloc[0]
#         best_price = pd.to_numeric(best_match.get("price", 0), errors='coerce')  # Ensure numeric
#         if pd.isna(best_price): best_price = 0.0
#
#         print(f"Best match found with price: {best_price}")
#         # print(f"Best match amenities count: {len(best_match.get('processed_amenities', []))}")
#
#         # --- STEP 7: Calculate price adjustments ---
#         print("Calculating price adjustments...")
#         test_amenities_set = set(test_amenities)  # test_amenities is already a list
#         best_match_amenities_list = best_match.get('processed_amenities', [])
#         if not isinstance(best_match_amenities_list, list):  # Ensure it's a list
#             best_match_amenities_list = []
#         best_amenities_set = set(best_match_amenities_list)
#
#         missing_amenities = best_amenities_set - test_amenities_set
#         extra_amenities = test_amenities_set - best_amenities_set
#         # print(f"Missing amenities in test vs best_match: {len(missing_amenities)}")
#         # print(f"Extra amenities in test vs best_match: {len(extra_amenities)}")
#
#         missing_impact = sum(amenity_impacts.get(amenity, 0) for amenity in missing_amenities)
#         extra_impact = sum(amenity_impacts.get(amenity, 0) for amenity in extra_amenities)
#         net_amenity_impact_percent = extra_impact - missing_impact  # This is a percentage impact
#
#         # print(f"Net amenity impact percentage: {net_amenity_impact_percent}%")
#
#         # Feature adjustments
#         feature_price_adjustment_total = 0
#         for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#             if col not in df.columns or col not in test.columns:
#                 continue
#
#             best_val = pd.to_numeric(best_match.get(col), errors='coerce')
#             test_val = pd.to_numeric(test[col].iloc[0], errors='coerce')
#
#             if pd.isna(best_val) or pd.isna(test_val): continue
#
#             if best_val != test_val:
#                 best_price_avg_for_feature = feature_price_means.get(col, {}).get(best_val, 0)
#                 test_price_avg_for_feature = feature_price_means.get(col, {}).get(test_val, 0)
#                 feature_price_adjustment_total += (test_price_avg_for_feature - best_price_avg_for_feature)
#         # print(f"Total feature price adjustment value: {feature_price_adjustment_total}")
#
#         # --- STEP 8: Calculate final recommended price ---
#         print("Calculating final price...")
#         # Start with the best match price
#         adjusted_price = best_price
#
#         # Apply amenity impact as a percentage
#         adjusted_price = adjusted_price * (1 + net_amenity_impact_percent / 100.0)
#
#         # Apply feature adjustment as a direct value
#         # This part of the logic seems a bit off from typical pricing models.
#         # Usually, you'd either use a regression model or adjust based on percentage impacts of features too.
#         # The original logic added multiple "adjusted_prices" and averaged them, which is unusual.
#         # A more standard approach is to adjust the best_match_price sequentially.
#         # For now, let's stick to a sequential adjustment:
#         adjusted_price += feature_price_adjustment_total  # Add the sum of feature price differences
#
#         # Ensure price is not negative
#         recommended_price = max(0.0, adjusted_price)
#
#         print(f"Base price (best match): {best_price}")
#         print(
#             f"Price after amenity adjustment ({net_amenity_impact_percent}%): {best_price * (1 + net_amenity_impact_percent / 100.0)}")
#         print(f"Total feature value adjustment: {feature_price_adjustment_total}")
#         print(f"Final Recommended price: {recommended_price}")
#         return round(recommended_price, 2)
#
#
#     except Exception as e:
#         print(f"Unexpected error in get_recommended_price: {e}")
#         import traceback
#         traceback.print_exc()
#         return 0.0


############################################################################### --- imp above

# --- Main Execution ---
# if __name__ == "__main__":
#     # Database Configuration
#     db_config = {
#         'host': '127.0.0.1',
#         'user': 'root',
#         'password': '',  # Add your password
#         'database': 'pricing'
#     }
#
#     # Default coordinates for process_dataframe
#     default_lat = 42.1713
#     default_lon = -73.9698
#
#     df_main_raw = pd.DataFrame()
#     df_test_single_row = pd.DataFrame()
#
#     try:
#         # 1. Fetch all data from rental_properties
#         print("Connecting to database for main rental properties data...")
#         conn = mysql.connector.connect(**db_config)
#         query_main = "SELECT * FROM rental_properties"
#         df_main_raw = pd.read_sql_query(query_main, conn)
#         print(f"Fetched {len(df_main_raw)} rows from rental_properties.")
#
#         if df_main_raw.empty:
#             print("Main rental_properties data is empty. Exiting.")
#             exit()
#
#         # 2. Process the main dataframe
#         print(f"Processing main dataframe with coordinates: lat={default_lat}, long={default_lon}")
#         # Ensure process_dataframe handles potential missing columns gracefully or select specific ones
#         df_processed_main = process_dataframe(df_main_raw.copy(), lat=default_lat, long=default_lon)
#         print(f"Main dataframe processed. Shape: {df_processed_main.shape}")
#
#         if df_processed_main.empty:
#             print("Processed main dataframe is empty. Exiting.")
#             exit()
#
#         # 3. Fetch a single row from userdynamiclistset for the test dataframe
#         print("Connecting to database for test property data (userdynamiclistset)...")
#         # Re-establish connection or use existing if still valid and no cursors are open
#         if not conn.is_connected():
#             conn = mysql.connector.connect(**db_config)
#
#         cursor = conn.cursor(dictionary=True)  # Fetch as dictionary
#         # Modify this query if you need a specific row, e.g., by ID
#         query_test = "SELECT * FROM userdynamiclistset ORDER BY id LIMIT 1"  # Example: get the first row by id
#         cursor.execute(query_test)
#         test_property_data_dict = cursor.fetchone()
#         cursor.close()
#
#         if test_property_data_dict:
#             # Convert the single row dictionary to a DataFrame
#             df_test_single_row = pd.DataFrame([test_property_data_dict])
#             print(f"Fetched test property data. Columns: {df_test_single_row.columns.tolist()}")
#         else:
#             print("No data found in userdynamiclistset to form the test DataFrame. Exiting.")
#             exit()
#
#         # 4. Call get_recommended_price
#         if not df_processed_main.empty and not df_test_single_row.empty:
#             print("\nCalling get_recommended_price...")
#             recommended_price = get_recommended_price(df_processed_main, df_test_single_row)
#             print(f"\n------------------------------------------")
#             print(f"FINAL RECOMMENDED PRICE: {recommended_price:.2f}")
#             print(f"------------------------------------------")
#         else:
#             print("Cannot calculate recommended price due to empty processed main or test dataframe.")
#
#     except mysql.connector.Error as err:
#         print(f"Database Error: {err}")
#     except FileNotFoundError:
#         print("Error: filter200.py not found. Make sure it's in the correct path.")
#     except Exception as e:
#         print(f"An unexpected error occurred: {e}")
#         import traceback
#
#         traceback.print_exc()
#     finally:
#         if 'conn' in locals() and conn.is_connected():
#             conn.close()
#             print("Database connection closed.")

#############################################################################################################################


#
# import pandas as pd
# import json  # Make sure json is imported
#
# # --- Import your custom functions ---
# # Assuming filter200.py is in the same directory or accessible in PYTHONPATH
# try:
#     from filter200 import process_dataframe
# except ImportError:
#     print("Error: Could not import process_dataframe from filter200.py.")
#     print("Make sure filter200.py is in the same directory or in your PYTHONPATH.")
#
#
#     # Define a placeholder if you want the script to run for testing other parts
#     def process_dataframe(df, lat, long):
#         print(f"Placeholder process_dataframe called with lat={lat}, long={long}. Returning original df.")
#         return df  # Placeholder returns original df
#
#
# def get_recommended_price(df: pd.DataFrame, test: pd.DataFrame) -> float:
#     """
#     Calculate recommended price based on property features and amenities
#
#     Parameters:
#     -----------
#     df : DataFrame
#         Reference properties with price data
#     test : DataFrame
#         Single property for which to calculate the recommended price
#
#     Returns:
#     --------
#     float : Recommended price
#     """
#     try:
#         # Check for empty dataframes
#         if df.empty or test.empty:
#             print("Empty dataframe provided to get_recommended_price")
#             return 0.0
#
#         # Make copies to avoid modifying original dataframes
#         df = df.copy()
#         test = test.copy()
#
#         # --- STEP 1: Process amenities lists ---
#         print("Processing amenities lists...")
#
#         def safe_convert_amenities(amenities_val):
#             """Convert various amenities formats to a list of strings"""
#             try:
#                 if pd.isna(amenities_val):
#                     return []
#                 if isinstance(amenities_val, list):
#                     return [str(item).lower() for item in amenities_val]
#                 if isinstance(amenities_val, str):
#                     try:
#                         result = json.loads(amenities_val)
#                         if isinstance(result, list):
#                             return [str(item).lower() for item in result]
#                     except (json.JSONDecodeError, TypeError):
#                         if '[' not in amenities_val and ']' not in amenities_val and ',' in amenities_val:
#                             return [item.strip().lower() for item in amenities_val.split(',')]
#                         return [amenities_val.lower()]
#                 return []
#             except Exception as e:
#                 print(f"Error in safe_convert_amenities for value '{amenities_val}': {e}")
#                 return []
#
#         if "amenities_list" in df.columns:
#             df["processed_amenities"] = df["amenities_list"].apply(safe_convert_amenities)
#         elif "amenities" in df.columns:
#             print("Warning: 'amenities_list' column not found in main dataframe, trying 'amenities'.")
#             df["processed_amenities"] = df["amenities"].apply(safe_convert_amenities)
#         else:
#             print("Warning: Neither 'amenities_list' nor 'amenities' column found in main dataframe.")
#             df["processed_amenities"] = pd.Series([[] for _ in range(len(df))], index=df.index)
#
#         test_amenities_col_name = None
#         if "amenities_list" in test.columns:
#             test_amenities_col_name = "amenities_list"
#         elif "amenities" in test.columns:
#             test_amenities_col_name = "amenities"
#
#         if test_amenities_col_name:
#             test_amenities = safe_convert_amenities(test[test_amenities_col_name].iloc[0])
#         else:
#             print("Warning: Neither 'amenities_list' nor 'amenities' column not found in test dataframe.")
#             test_amenities = []
#         print(f"Test property has {len(test_amenities)} amenities: {test_amenities[:5]}...")
#
#         # --- STEP 2: Calculate amenity impacts ---
#         print("Calculating amenity impacts...")
#         all_amenities = set()
#         for amenity_list in df["processed_amenities"]:
#             try:
#                 if isinstance(amenity_list, list):
#                     all_amenities.update(amenity_list)
#             except Exception as e:
#                 print(f"Error updating all_amenities: {e}")
#                 print(f"Problematic amenity_list: {amenity_list}, Type: {type(amenity_list)}")
#         print(f"Found {len(all_amenities)} unique amenities in main df")
#
#         amenity_impacts = {}
#         if "price" not in df.columns:
#             print("Error: 'price' column missing from main dataframe. Cannot calculate amenity impacts.")
#         else:
#             df["price"] = pd.to_numeric(df["price"], errors='coerce').fillna(0)
#             for amenity in all_amenities:
#                 try:
#                     has_amenity = df["processed_amenities"].apply(lambda x: isinstance(x, list) and amenity in x)
#                 except Exception as e:
#                     print(f"Error checking amenity presence for '{amenity}': {e}")
#                     continue
#                 if has_amenity.sum() > 0 and (~has_amenity).sum() > 0:
#                     avg_price_with = df.loc[has_amenity, "price"].mean()
#                     avg_price_without = df.loc[~has_amenity, "price"].mean()
#                     if pd.notna(avg_price_with) and pd.notna(avg_price_without) and avg_price_without > 0:
#                         impact = ((avg_price_with - avg_price_without) / avg_price_without) * 100
#                         amenity_impacts[amenity] = round(impact, 2)
#                     else:
#                         amenity_impacts[amenity] = 0
#                 else:
#                     amenity_impacts[amenity] = 0
#         print(f"Calculated impacts for {len(amenity_impacts)} amenities.")
#
#         # --- STEP 3: Calculate feature price averages ---
#         print("Calculating feature price averages...")
#         feature_price_means = {}
#         if "price" in df.columns:
#             for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#                 if col in df.columns:
#                     df[col] = pd.to_numeric(df[col], errors='coerce')
#                     valid_rows = df.dropna(subset=[col, "price"])
#                     if not valid_rows.empty:
#                         feature_price_means[col] = valid_rows.groupby(col)["price"].mean().to_dict()
#                     else:
#                         feature_price_means[col] = {}
#                 else:
#                     print(f"Warning: Feature column '{col}' not found in main dataframe.")
#                     feature_price_means[col] = {}
#         else:
#             print("Skipping feature price averages as 'price' column is missing.")
#
#         # --- STEP 4: Calculate amenity match scores ---
#         print("Calculating amenity match scores for main df...")
#
#         def calc_amenity_score(property_amenities_list):
#             try:
#                 if not isinstance(property_amenities_list, list): return 0
#                 score = 0
#                 for amenity in property_amenities_list:
#                     if amenity in test_amenities:
#                         score += amenity_impacts.get(amenity, 0)
#                 return score
#             except Exception as e:
#                 print(f"Error in calc_amenity_score: {e}")
#                 return 0
#
#         df["amenity_score"] = df["processed_amenities"].apply(calc_amenity_score)
#
#         # --- STEP 5: Calculate feature match scores ---
#         print("Calculating feature match scores for main df...")
#
#         def calc_feature_score(row):
#             try:
#                 score = 0
#                 test_features_present = all(
#                     f_col in test.columns for f_col in ["beds", "bedrooms", "bathrooms", "guests"])
#                 if not test_features_present: return 0
#                 for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#                     if col not in df.columns or col not in test.columns: continue
#                     from_val = row[col]
#                     to_val = test[col].iloc[0]
#                     from_val_numeric = pd.to_numeric(from_val, errors='coerce')
#                     to_val_numeric = pd.to_numeric(to_val, errors='coerce')
#                     if pd.isna(from_val_numeric) or pd.isna(to_val_numeric): continue
#                     from_price = feature_price_means.get(col, {}).get(from_val_numeric, 0)
#                     to_price = feature_price_means.get(col, {}).get(to_val_numeric, 0)
#                     score += (to_price - from_price)
#                 return score
#             except Exception as e:
#                 print(f"Error in calc_feature_score for row: {e}")
#                 return 0
#
#         df["feature_score"] = df.apply(calc_feature_score, axis=1)
#
#         # --- STEP 6: Find best matching property ---
#         print("Finding best match...")
#         df["total_score"] = df["amenity_score"] + df["feature_score"]
#         if df.empty or df["total_score"].isna().all():
#             print("Error: No properties found for comparison or all scores are NaN.")
#             return 0.0
#         df_sorted = df.sort_values("total_score", ascending=False, na_position='last')
#         if df_sorted.empty:
#             print("Error: No properties found after sorting.")
#             return 0.0
#         best_match = df_sorted.iloc[0]
#
#         # --- CORRECTED LINE HERE ---
#         best_price_raw = best_match.get("price", 0)  # Get the raw value
#         best_price = pd.to_numeric(best_price_raw, errors='coerce')  # Convert to numeric
#         if pd.isna(best_price):  # Check if the result is NaN
#             best_price = 0.0
#         # --- END OF CORRECTION ---
#
#         print(f"Best match found with price: {best_price:.2f}")
#
#         # --- STEP 7: Calculate price adjustments ---
#         print("Calculating price adjustments...")
#         test_amenities_set = set(test_amenities)
#         best_match_amenities_list = best_match.get('processed_amenities', [])
#         if not isinstance(best_match_amenities_list, list): best_match_amenities_list = []
#         best_amenities_set = set(best_match_amenities_list)
#         missing_amenities = best_amenities_set - test_amenities_set
#         extra_amenities = test_amenities_set - best_amenities_set
#         missing_impact = sum(amenity_impacts.get(amenity, 0) for amenity in missing_amenities)
#         extra_impact = sum(amenity_impacts.get(amenity, 0) for amenity in extra_amenities)
#         net_amenity_impact_percent = extra_impact - missing_impact
#
#         feature_price_adjustment_total = 0
#         for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#             if col not in df.columns or col not in test.columns: continue
#             best_val = pd.to_numeric(best_match.get(col), errors='coerce')
#             test_val = pd.to_numeric(test[col].iloc[0], errors='coerce')
#             if pd.isna(best_val) or pd.isna(test_val): continue
#             if best_val != test_val:
#                 best_price_avg_for_feature = feature_price_means.get(col, {}).get(best_val, 0)
#                 test_price_avg_for_feature = feature_price_means.get(col, {}).get(test_val, 0)
#                 feature_price_adjustment_total += (test_price_avg_for_feature - best_price_avg_for_feature)
#
#         # --- STEP 8: Calculate final recommended price ---
#         print("Calculating final price...")
#
#         price_after_amenity_adj = best_price * (1 + net_amenity_impact_percent / 100.0)
#         original_feature_price_adjustment_total = feature_price_adjustment_total
#
#         # Define the minimum ratio of the amenity-adjusted price that the final price should not fall below
#         # due to negative feature adjustments.
#         MIN_PRICE_RATIO_CAP = 0.1  # e.g., 10%. Features cannot reduce price below 10% of price_after_amenity_adj.
#
#         if price_after_amenity_adj > 0:
#             price_floor_for_feature_impact = price_after_amenity_adj * MIN_PRICE_RATIO_CAP
#
#             if price_after_amenity_adj + feature_price_adjustment_total < price_floor_for_feature_impact:
#                 # Cap the feature_price_adjustment_total
#                 feature_price_adjustment_total = price_floor_for_feature_impact - price_after_amenity_adj
#                 print(f"    INFO: Feature adjustment capped to prevent excessive reduction.")
#                 print(f"          Original feature adjustment: {original_feature_price_adjustment_total:.2f}")
#                 print(f"          Capped feature adjustment: {feature_price_adjustment_total:.2f}")
#                 print(
#                     f"          Price after amenity adj: {price_after_amenity_adj:.2f}, Min price floor for feature impact: {price_floor_for_feature_impact:.2f}")
#
#         adjusted_price_final = price_after_amenity_adj + feature_price_adjustment_total
#         recommended_price = max(0.0, adjusted_price_final)  # Final hard floor at 0.0
#
#         print(f"Base price (best match): {best_price:.2f}")
#         print(f"Price after amenity adjustment ({net_amenity_impact_percent:.2f}%): {price_after_amenity_adj:.2f}")
#         print(f"Total feature value adjustment (applied): {feature_price_adjustment_total:.2f}")
#         print(f"Final Recommended price: {recommended_price:.2f}")
#         return round(recommended_price, 2)
#
#     except Exception as e:
#         print(f"Unexpected error in get_recommended_price: {e}")
#         import traceback
#         traceback.print_exc()
#         return 0.0
#
# # Example Usage (assuming you have pandas DataFrames `main_df` and `test_df` prepared):
# # recommended_price = get_recommended_price(main_df, test_df)
# # print(f"Algorithm Recommended Price: ${recommended_price}")
##################################################################### ----------- imp below used



# import pandas as pd
# import json  # Make sure json is imported
# import traceback  # For detailed error logging
#
# # --- Import your custom functions ---
# # Assuming filter200.py is in the same directory or accessible in PYTHONPATH
# try:
#     from filter200 import select_comparables_for_pricing
# except ImportError:
#     print("Error: Could not import process_dataframe from filter200.py.")
#     print("Make sure filter200.py is in the same directory or in your PYTHONPATH.")
#
#
#     # Define a placeholder if you want the script to run for testing other parts
#     def select_comparables_for_pricing(df, lat, long):
#         print(f"Placeholder select_comparables_for_pricing called with lat={lat}, long={long}. Returning original df.")
#         return df  # Placeholder returns original df
#
#
# def get_recommended_price(df: pd.DataFrame, test: pd.DataFrame) -> float:
#     """
#     Calculate recommended price based on property features and amenities,
#     with capping for extremely negative amenity and feature impacts.
#
#     Parameters:
#     -----------
#     df : DataFrame
#         Reference properties with price data
#     test : DataFrame
#         Single property for which to calculate the recommended price
#
#     Returns:
#     --------
#     float : Recommended price
#     """
#     try:
#         # Check for empty dataframes
#         if df.empty or test.empty:
#             print("Empty dataframe provided to get_recommended_price")
#             return 0.0
#
#         # Make copies to avoid modifying original dataframes
#         df = df.copy()
#         test = test.copy()
#
#         # --- STEP 1: Process amenities lists ---
#         print("Processing amenities lists...")
#
#         def safe_convert_amenities(amenities_val):
#             """Convert various amenities formats to a list of strings"""
#             try:
#                 if pd.isna(amenities_val):
#                     return []
#                 if isinstance(amenities_val, list):
#                     return [str(item).lower() for item in amenities_val]
#                 if isinstance(amenities_val, str):
#                     try:
#                         result = json.loads(amenities_val)
#                         if isinstance(result, list):
#                             return [str(item).lower() for item in result]
#                     except (json.JSONDecodeError, TypeError):
#                         if '[' not in amenities_val and ']' not in amenities_val and ',' in amenities_val:
#                             return [item.strip().lower() for item in amenities_val.split(',')]
#                         return [amenities_val.lower()]
#                 return []
#             except Exception as e:
#                 print(f"Error in safe_convert_amenities for value '{amenities_val}': {e}")
#                 return []
#
#         if "amenities_list" in df.columns:
#             df["processed_amenities"] = df["amenities_list"].apply(safe_convert_amenities)
#         elif "amenities" in df.columns:
#             print("Warning: 'amenities_list' column not found in main dataframe, trying 'amenities'.")
#             df["processed_amenities"] = df["amenities"].apply(safe_convert_amenities)
#         else:
#             print("Warning: Neither 'amenities_list' nor 'amenities' column found in main dataframe.")
#             df["processed_amenities"] = pd.Series([[] for _ in range(len(df))], index=df.index)
#
#         test_amenities_col_name = None
#         if "amenities_list" in test.columns:
#             test_amenities_col_name = "amenities_list"
#         elif "amenities" in test.columns:
#             test_amenities_col_name = "amenities"
#
#         if test_amenities_col_name:
#             test_amenities = safe_convert_amenities(test[test_amenities_col_name].iloc[0])
#         else:
#             print("Warning: Neither 'amenities_list' nor 'amenities' column not found in test dataframe.")
#             test_amenities = []
#         print(f"Test property has {len(test_amenities)} amenities: {test_amenities[:5]}...")
#
#         # --- STEP 2: Calculate amenity impacts ---
#         print("Calculating amenity impacts...")
#         all_amenities = set()
#         for amenity_list in df["processed_amenities"]:
#             try:
#                 if isinstance(amenity_list, list):
#                     all_amenities.update(amenity_list)
#             except Exception as e:
#                 print(f"Error updating all_amenities: {e}")
#                 print(f"Problematic amenity_list: {amenity_list}, Type: {type(amenity_list)}")
#         print(f"Found {len(all_amenities)} unique amenities in main df")
#
#         amenity_impacts = {}
#         if "price" not in df.columns:
#             print("Error: 'price' column missing from main dataframe. Cannot calculate amenity impacts.")
#         else:
#             df["price"] = pd.to_numeric(df["price"], errors='coerce').fillna(0)
#             for amenity in all_amenities:
#                 try:
#                     has_amenity = df["processed_amenities"].apply(lambda x: isinstance(x, list) and amenity in x)
#                 except Exception as e:
#                     print(f"Error checking amenity presence for '{amenity}': {e}")
#                     continue
#                 if has_amenity.sum() > 0 and (~has_amenity).sum() > 0:
#                     avg_price_with = df.loc[has_amenity, "price"].mean()
#                     avg_price_without = df.loc[~has_amenity, "price"].mean()
#                     if pd.notna(avg_price_with) and pd.notna(avg_price_without) and avg_price_without > 0:
#                         impact = ((avg_price_with - avg_price_without) / avg_price_without) * 100
#                         amenity_impacts[amenity] = round(impact, 2)
#                     else:
#                         amenity_impacts[amenity] = 0
#                 else:
#                     amenity_impacts[amenity] = 0
#         print(f"Calculated impacts for {len(amenity_impacts)} amenities.")
#
#         # --- STEP 3: Calculate feature price averages ---
#         print("Calculating feature price averages...")
#         feature_price_means = {}
#         if "price" in df.columns:
#             for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#                 if col in df.columns:
#                     df[col] = pd.to_numeric(df[col], errors='coerce')
#                     valid_rows = df.dropna(subset=[col, "price"])
#                     if not valid_rows.empty:
#                         feature_price_means[col] = valid_rows.groupby(col)["price"].mean().to_dict()
#                     else:
#                         feature_price_means[col] = {}
#                 else:
#                     print(f"Warning: Feature column '{col}' not found in main dataframe.")
#                     feature_price_means[col] = {}
#         else:
#             print("Skipping feature price averages as 'price' column is missing.")
#
#         # --- STEP 4: Calculate amenity match scores ---
#         print("Calculating amenity match scores for main df...")
#
#         def calc_amenity_score(property_amenities_list):
#             try:
#                 if not isinstance(property_amenities_list, list): return 0
#                 score = 0
#                 for amenity in property_amenities_list:
#                     if amenity in test_amenities:
#                         score += amenity_impacts.get(amenity, 0)
#                 return score
#             except Exception as e:
#                 print(f"Error in calc_amenity_score: {e}")
#                 return 0
#
#         df["amenity_score"] = df["processed_amenities"].apply(calc_amenity_score)
#
#         # --- STEP 5: Calculate feature match scores ---
#         print("Calculating feature match scores for main df...")
#
#         def calc_feature_score(row):
#             try:
#                 score = 0
#                 test_features_present = all(
#                     f_col in test.columns for f_col in ["beds", "bedrooms", "bathrooms", "guests"])
#                 if not test_features_present: return 0
#                 for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#                     if col not in df.columns or col not in test.columns: continue
#                     from_val = row[col]
#                     to_val = test[col].iloc[0]
#                     from_val_numeric = pd.to_numeric(from_val, errors='coerce')
#                     to_val_numeric = pd.to_numeric(to_val, errors='coerce')
#                     if pd.isna(from_val_numeric) or pd.isna(to_val_numeric): continue
#                     from_price = feature_price_means.get(col, {}).get(from_val_numeric, 0)
#                     to_price = feature_price_means.get(col, {}).get(to_val_numeric, 0)
#                     score += (to_price - from_price)
#                 return score
#             except Exception as e:
#                 print(f"Error in calc_feature_score for row: {e}")
#                 return 0
#
#         df["feature_score"] = df.apply(calc_feature_score, axis=1)
#
#         # --- STEP 6: Find best matching property ---
#         print("Finding best match...")
#         df["total_score"] = df["amenity_score"] + df["feature_score"]
#         if df.empty or df["total_score"].isna().all():
#             print("Error: No properties found for comparison or all scores are NaN.")
#             return 0.0
#         df_sorted = df.sort_values("total_score", ascending=False, na_position='last')
#         if df_sorted.empty:
#             print("Error: No properties found after sorting.")
#             return 0.0
#         best_match = df_sorted.iloc[0]
#
#         best_price_raw = best_match.get("price", 0)
#         best_price = pd.to_numeric(best_price_raw, errors='coerce')
#         if pd.isna(best_price):
#             best_price = 0.0
#
#         print(f"Best match found with price: {best_price:.2f}")
#
#         # --- STEP 7: Calculate price adjustments ---
#         print("Calculating price adjustments...")
#         test_amenities_set = set(test_amenities)
#         best_match_amenities_list = best_match.get('processed_amenities', [])
#         if not isinstance(best_match_amenities_list, list): best_match_amenities_list = []
#         best_amenities_set = set(best_match_amenities_list)
#         missing_amenities = best_amenities_set - test_amenities_set
#         extra_amenities = test_amenities_set - best_amenities_set
#         missing_impact = sum(amenity_impacts.get(amenity, 0) for amenity in missing_amenities)
#         extra_impact = sum(amenity_impacts.get(amenity, 0) for amenity in extra_amenities)
#         net_amenity_impact_percent = extra_impact - missing_impact
#
#         feature_price_adjustment_total = 0
#         for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#             if col not in df.columns or col not in test.columns: continue
#             best_val = pd.to_numeric(best_match.get(col), errors='coerce')
#             test_val = pd.to_numeric(test[col].iloc[0], errors='coerce')
#             if pd.isna(best_val) or pd.isna(test_val): continue
#             if best_val != test_val:
#                 best_price_avg_for_feature = feature_price_means.get(col, {}).get(best_val, 0)
#                 test_price_avg_for_feature = feature_price_means.get(col, {}).get(test_val, 0)
#                 feature_price_adjustment_total += (test_price_avg_for_feature - best_price_avg_for_feature)
#             if pd.isna(best_val) or pd.isna(test_val): continue
#             if best_val != test_val:
#                 adjustment = test_price_avg_for_feature - best_price_avg_for_feature
#                 print(
#                     f"      {col}: Test_Avg({test_val})={test_price_avg_for_feature:.2f} - BestMatch_Avg({best_val})={best_price_avg_for_feature:.2f} = Adjustment: {adjustment:.2f}")
#                 feature_price_adjustment_total += adjustment
#             else:
#                 print(f"      {col}: Test({test_val}) and BestMatch({best_val}) are same. Adjustment: 0.00")
#         print(f"    Total (Summed) Feature Adjustment before capping: {feature_price_adjustment_total:.2f}")
#
#         # --- STEP 8: Calculate final recommended price with CAPPING ---
#         print("Calculating final price...")
#
#         # --- AMENITY ADJUSTMENT and CAPPING ---
#         price_after_amenity_adj_raw = best_price * (1 + net_amenity_impact_percent / 100.0)
#
#         # Cap for extremely negative amenity impact.
#         # Price shouldn't go below this ratio of best_price due to amenities alone.
#         # Set to 0 if you don't want to cap amenity impact directly like this.
#         MIN_AMENITY_ADJUSTED_PRICE_RATIO_CAP = 0.05  # e.g., 5%
#
#         price_after_amenity_adj = price_after_amenity_adj_raw
#         if best_price > 0:  # Only apply this cap if best_price is positive
#             amenity_price_floor = best_price * MIN_AMENITY_ADJUSTED_PRICE_RATIO_CAP
#             if price_after_amenity_adj_raw < amenity_price_floor:
#                 print(
#                     f"    INFO: Amenity adjusted price capped. Original raw: {price_after_amenity_adj_raw:.2f}, Floor: {amenity_price_floor:.2f}")
#                 price_after_amenity_adj = amenity_price_floor
#
#         # Ensure price is at least 0 after amenity adjustment if a cap was intended
#         # This also handles cases where best_price might be 0.
#         price_after_amenity_adj = max(0.0, price_after_amenity_adj)
#
#         # --- FEATURE ADJUSTMENT and CAPPING ---
#         original_feature_price_adjustment_total = feature_price_adjustment_total
#
#         # Cap for extremely negative feature impact.
#         # Price shouldn't go below this ratio of price_after_amenity_adj due to features.
#         MIN_FEATURE_ADJUSTED_PRICE_RATIO_CAP = 0.10  # e.g., 10%
#
#         # Store the feature adjustment that will actually be applied
#         applied_feature_price_adjustment_total = original_feature_price_adjustment_total
#
#         if price_after_amenity_adj > 0:  # Only apply feature cap if price after amenity adj is positive
#             feature_price_floor = price_after_amenity_adj * MIN_FEATURE_ADJUSTED_PRICE_RATIO_CAP
#
#             if price_after_amenity_adj + original_feature_price_adjustment_total < feature_price_floor:
#                 # Recalculate the feature adjustment to meet the floor
#                 applied_feature_price_adjustment_total = feature_price_floor - price_after_amenity_adj
#                 print(f"    INFO: Feature adjustment capped to prevent excessive reduction.")
#                 print(f"          Original feature adjustment: {original_feature_price_adjustment_total:.2f}")
#                 print(f"          Price after amenity adj (potentially capped): {price_after_amenity_adj:.2f}")
#                 print(f"          Feature impact floor: {feature_price_floor:.2f}")
#                 print(f"          Capped feature adjustment: {applied_feature_price_adjustment_total:.2f}")
#
#         adjusted_price_final = price_after_amenity_adj + applied_feature_price_adjustment_total
#
#         # Final absolute floor at 0.0
#         recommended_price = max(0.0, adjusted_price_final)
#
#         # --- Logging Final Price Calculation ---
#         print(f"Base price (best match): {best_price:.2f}")
#         print(f"Net amenity impact: {net_amenity_impact_percent:.2f}%")
#         print(f"Price after amenity adjustment (raw calculation): {price_after_amenity_adj_raw:.2f}")
#         if price_after_amenity_adj != price_after_amenity_adj_raw:
#             print(f"Price after amenity adjustment (after amenity cap): {price_after_amenity_adj:.2f}")
#         else:
#             print(f"Price after amenity adjustment (no amenity cap applied): {price_after_amenity_adj:.2f}")
#
#         print(f"Original feature value adjustment: {original_feature_price_adjustment_total:.2f}")
#         if applied_feature_price_adjustment_total != original_feature_price_adjustment_total:
#             print(f"Applied feature value adjustment (after feature cap): {applied_feature_price_adjustment_total:.2f}")
#         else:
#             print(
#                 f"Applied feature value adjustment (no feature cap applied): {applied_feature_price_adjustment_total:.2f}")
#
#         print(f"Price before final 0.0 floor (AmenityAdjPrice + AppliedFeatureAdj): {adjusted_price_final:.2f}")
#         print(f"Final Recommended price: {recommended_price:.2f}")
#
#         return round(recommended_price, 2)
#
#     except Exception as e:
#         print(f"Unexpected error in get_recommended_price: {e}")
#         traceback.print_exc()
#         return 0.0


# Example Usage (assuming you have pandas DataFrames `main_df` and `test_df` prepared):
#
#
#################################################################################### ------- imp below
#
# import pandas as pd
# import json  # Make sure json is imported
# import traceback  # For detailed error logging
#
# # --- Import your custom functions ---
# # Assuming filter200.py is in the same directory or accessible in PYTHONPATH
# try:
#     from filter200 import process_dataframe
# except ImportError:
#     print("Error: Could not import process_dataframe from filter200.py.")
#     print("Make sure filter200.py is in the same directory or in your PYTHONPATH.")
#
#
#     # Define a placeholder if you want the script to run for testing other parts
#     def process_dataframe(df, lat, long):
#         print(f"Placeholder process_dataframe called with lat={lat}, long={long}. Returning original df.")
#         return df  # Placeholder returns original df
#
#
# def get_recommended_price(df: pd.DataFrame, test: pd.DataFrame) -> float:
#     """
#     Calculate recommended price based on property features and amenities,
#     with capping for extremely negative amenity and feature impacts.
#     Feature adjustments are AVERAGED.
#
#     Parameters:
#     -----------
#     df : DataFrame
#         Reference properties with price data
#     test : DataFrame
#         Single property for which to calculate the recommended price
#
#     Returns:
#     --------
#     float : Recommended price
#     """
#     try:
#         # Check for empty dataframes
#         if df.empty or test.empty:
#             print("Empty dataframe provided to get_recommended_price")
#             return 0.0
#
#         # Make copies to avoid modifying original dataframes
#         df = df.copy()
#         test = test.copy()
#
#         # --- STEP 1: Process amenities lists (Identical to previous version) ---
#         print("Processing amenities lists...")
#
#         # ... (amenity processing code remains the same) ...
#         def safe_convert_amenities(amenities_val):
#             try:
#                 if pd.isna(amenities_val): return []
#                 if isinstance(amenities_val, list): return [str(item).lower() for item in amenities_val]
#                 if isinstance(amenities_val, str):
#                     try:
#                         result = json.loads(amenities_val)
#                         if isinstance(result, list): return [str(item).lower() for item in result]
#                     except (json.JSONDecodeError, TypeError):
#                         if '[' not in amenities_val and ']' not in amenities_val and ',' in amenities_val:
#                             return [item.strip().lower() for item in amenities_val.split(',')]
#                         return [amenities_val.lower()]
#                 return []
#             except Exception as e:
#                 print(f"Error in safe_convert_amenities for value '{amenities_val}': {e}")
#                 return []
#
#         if "amenities_list" in df.columns:
#             df["processed_amenities"] = df["amenities_list"].apply(safe_convert_amenities)
#         elif "amenities" in df.columns:
#             print("Warning: 'amenities_list' column not found in main dataframe, trying 'amenities'.")
#             df["processed_amenities"] = df["amenities"].apply(safe_convert_amenities)
#         else:
#             print("Warning: Neither 'amenities_list' nor 'amenities' column found in main dataframe.")
#             df["processed_amenities"] = pd.Series([[] for _ in range(len(df))], index=df.index)
#
#         test_amenities_col_name = None
#         if "amenities_list" in test.columns:
#             test_amenities_col_name = "amenities_list"
#         elif "amenities" in test.columns:
#             test_amenities_col_name = "amenities"
#
#         if test_amenities_col_name:
#             test_amenities = safe_convert_amenities(test[test_amenities_col_name].iloc[0])
#         else:
#             print("Warning: Neither 'amenities_list' nor 'amenities' column not found in test dataframe.")
#             test_amenities = []
#         print(f"Test property has {len(test_amenities)} amenities: {test_amenities[:5]}...")
#
#         # --- STEP 2: Calculate amenity impacts (Identical) ---
#         print("Calculating amenity impacts...")
#         # ... (amenity impact calculation code remains the same) ...
#         all_amenities = set()
#         for amenity_list in df["processed_amenities"]:
#             try:
#                 if isinstance(amenity_list, list): all_amenities.update(amenity_list)
#             except Exception as e:
#                 print(f"Error updating all_amenities: {e}")
#                 print(f"Problematic amenity_list: {amenity_list}, Type: {type(amenity_list)}")
#         print(f"Found {len(all_amenities)} unique amenities in main df")
#
#         amenity_impacts = {}
#         if "price" not in df.columns:
#             print("Error: 'price' column missing from main dataframe. Cannot calculate amenity impacts.")
#         else:
#             df["price"] = pd.to_numeric(df["price"], errors='coerce').fillna(0)
#             for amenity in all_amenities:
#                 try:
#                     has_amenity = df["processed_amenities"].apply(lambda x: isinstance(x, list) and amenity in x)
#                 except Exception as e:
#                     print(f"Error checking amenity presence for '{amenity}': {e}")
#                     continue
#                 if has_amenity.sum() > 0 and (~has_amenity).sum() > 0:
#                     avg_price_with = df.loc[has_amenity, "price"].mean()
#                     avg_price_without = df.loc[~has_amenity, "price"].mean()
#                     if pd.notna(avg_price_with) and pd.notna(avg_price_without) and avg_price_without > 0:
#                         impact = ((avg_price_with - avg_price_without) / avg_price_without) * 100
#                         amenity_impacts[amenity] = round(impact, 2)
#                     else:
#                         amenity_impacts[amenity] = 0
#                 else:
#                     amenity_impacts[amenity] = 0
#         print(f"Calculated impacts for {len(amenity_impacts)} amenities.")
#
#         # --- STEP 3: Calculate feature price averages (Identical) ---
#         print("Calculating feature price averages...")
#         # ... (feature price average calculation code remains the same) ...
#         feature_price_means = {}
#         if "price" in df.columns:
#             for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#                 if col in df.columns:
#                     df[col] = pd.to_numeric(df[col], errors='coerce')
#                     valid_rows = df.dropna(subset=[col, "price"])
#                     if not valid_rows.empty:
#                         feature_price_means[col] = valid_rows.groupby(col)["price"].mean().to_dict()
#                     else:
#                         feature_price_means[col] = {}
#                 else:
#                     print(f"Warning: Feature column '{col}' not found in main dataframe.")
#                     feature_price_means[col] = {}
#         else:
#             print("Skipping feature price averages as 'price' column is missing.")
#
#         # --- STEP 4: Calculate amenity match scores (Identical) ---
#         print("Calculating amenity match scores for main df...")
#
#         # ... (amenity score calculation code remains the same) ...
#         def calc_amenity_score(property_amenities_list):
#             try:
#                 if not isinstance(property_amenities_list, list): return 0
#                 score = 0
#                 for amenity in property_amenities_list:
#                     if amenity in test_amenities: score += amenity_impacts.get(amenity, 0)
#                 return score
#             except Exception as e:
#                 print(f"Error in calc_amenity_score: {e}")
#                 return 0
#
#         df["amenity_score"] = df["processed_amenities"].apply(calc_amenity_score)
#
#         # --- STEP 5: Calculate feature match scores (Identical) ---
#         print("Calculating feature match scores for main df...")
#
#         # ... (feature score calculation code remains the same) ...
#         def calc_feature_score(row):
#             try:
#                 score = 0
#                 test_features_present = all(
#                     f_col in test.columns for f_col in ["beds", "bedrooms", "bathrooms", "guests"])
#                 if not test_features_present: return 0
#                 for col in ["beds", "bedrooms", "bathrooms", "guests"]:
#                     if col not in df.columns or col not in test.columns: continue
#                     from_val = row[col]
#                     to_val = test[col].iloc[0]
#                     from_val_numeric = pd.to_numeric(from_val, errors='coerce')
#                     to_val_numeric = pd.to_numeric(to_val, errors='coerce')
#                     if pd.isna(from_val_numeric) or pd.isna(to_val_numeric): continue
#                     from_price = feature_price_means.get(col, {}).get(from_val_numeric, 0)
#                     to_price = feature_price_means.get(col, {}).get(to_val_numeric, 0)
#                     score += (to_price - from_price)
#                 return score
#             except Exception as e:
#                 print(f"Error in calc_feature_score for row: {e}")
#                 return 0
#
#         df["feature_score"] = df.apply(calc_feature_score, axis=1)
#
#         # --- STEP 6: Find best matching property (Identical) ---
#         print("Finding best match...")
#         # ... (best match finding code remains the same) ...
#         df["total_score"] = df["amenity_score"] + df["feature_score"]
#         if df.empty or df["total_score"].isna().all():
#             print("Error: No properties found for comparison or all scores are NaN.")
#             return 0.0
#         df_sorted = df.sort_values("total_score", ascending=False, na_position='last')
#         if df_sorted.empty:
#             print("Error: No properties found after sorting.")
#             return 0.0
#         best_match = df_sorted.iloc[0]
#
#         best_price_raw = best_match.get("price", 0)
#         best_price = pd.to_numeric(best_price_raw, errors='coerce')
#         if pd.isna(best_price): best_price = 0.0
#         print(f"Best match found with price: {best_price:.2f}")
#
#         # --- STEP 7: Calculate price adjustments (MODIFIED FOR AVERAGE FEATURE ADJUSTMENT) ---
#         print("Calculating price adjustments...")
#         test_amenities_set = set(test_amenities)
#         best_match_amenities_list = best_match.get('processed_amenities', [])
#         if not isinstance(best_match_amenities_list, list): best_match_amenities_list = []
#         best_amenities_set = set(best_match_amenities_list)
#         missing_amenities = best_amenities_set - test_amenities_set
#         extra_amenities = test_amenities_set - best_amenities_set
#         missing_impact = sum(amenity_impacts.get(amenity, 0) for amenity in missing_amenities)
#         extra_impact = sum(amenity_impacts.get(amenity, 0) for amenity in extra_amenities)
#         net_amenity_impact_percent = extra_impact - missing_impact
#
#         # MODIFICATION: Calculate average feature adjustment
#         individual_feature_adjustments = []
#         feature_cols_for_adjustment = ["beds", "bedrooms", "bathrooms", "guests"]
#
#         for col in feature_cols_for_adjustment:
#             if col not in df.columns or col not in test.columns:
#                 print(f"Warning: Feature '{col}' missing in df or test_df for adjustment calc.")
#                 continue  # Skip if column is missing in either DataFrame
#
#             best_val = pd.to_numeric(best_match.get(col), errors='coerce')
#             test_val = pd.to_numeric(test[col].iloc[0], errors='coerce')
#
#             if pd.isna(best_val) or pd.isna(test_val):
#                 print(
#                     f"Warning: NaN value for feature '{col}' in best_match or test_df. best: {best_val}, test: {test_val}")
#                 continue  # Skip if values are NaN
#
#             if best_val != test_val:
#                 best_price_avg_for_feature = feature_price_means.get(col, {}).get(best_val, 0)
#                 test_price_avg_for_feature = feature_price_means.get(col, {}).get(test_val, 0)
#                 adjustment = test_price_avg_for_feature - best_price_avg_for_feature
#                 individual_feature_adjustments.append(adjustment)
#             # If best_val == test_val, the adjustment is 0, so we can optionally append 0
#             # or just skip, the average will be correct if we only average non-zero diffs
#             # For simplicity, let's only consider actual differences.
#             # If you want to include features with no difference as a '0' adjustment in the average:
#             # else:
#             #     individual_feature_adjustments.append(0)
#
#         if individual_feature_adjustments:  # If there were any features to compare
#             avg_feature_price_adjustment = sum(individual_feature_adjustments) / len(individual_feature_adjustments)
#         else:  # No comparable features found or all were NaN
#             avg_feature_price_adjustment = 0.0
#         # END OF MODIFICATION for average feature adjustment
#
#         # --- STEP 8: Calculate final recommended price with CAPPING (Uses avg_feature_price_adjustment) ---
#         print("Calculating final price...")
#
#         price_after_amenity_adj_raw = best_price * (1 + net_amenity_impact_percent / 100.0)
#
#         MIN_AMENITY_ADJUSTED_PRICE_RATIO_CAP = 0.05
#
#         price_after_amenity_adj = price_after_amenity_adj_raw
#         if best_price > 0:
#             amenity_price_floor = best_price * MIN_AMENITY_ADJUSTED_PRICE_RATIO_CAP
#             if price_after_amenity_adj_raw < amenity_price_floor:
#                 print(
#                     f"    INFO: Amenity adjusted price capped. Original raw: {price_after_amenity_adj_raw:.2f}, Floor: {amenity_price_floor:.2f}")
#                 price_after_amenity_adj = amenity_price_floor
#
#         price_after_amenity_adj = max(0.0, price_after_amenity_adj)
#
#         # Use the calculated average feature adjustment
#         original_feature_price_adjustment_total = avg_feature_price_adjustment  # Renamed for consistency with capping logic
#
#         MIN_FEATURE_ADJUSTED_PRICE_RATIO_CAP = 0.10
#
#         applied_feature_price_adjustment_total = original_feature_price_adjustment_total
#
#         if price_after_amenity_adj > 0:
#             feature_price_floor = price_after_amenity_adj * MIN_FEATURE_ADJUSTED_PRICE_RATIO_CAP
#
#             if price_after_amenity_adj + original_feature_price_adjustment_total < feature_price_floor:
#                 applied_feature_price_adjustment_total = feature_price_floor - price_after_amenity_adj
#                 print(f"    INFO: AVG Feature adjustment capped to prevent excessive reduction.")
#                 print(f"          Original AVG feature adjustment: {original_feature_price_adjustment_total:.2f}")
#                 print(f"          Price after amenity adj (potentially capped): {price_after_amenity_adj:.2f}")
#                 print(f"          Feature impact floor: {feature_price_floor:.2f}")
#                 print(f"          Capped AVG feature adjustment: {applied_feature_price_adjustment_total:.2f}")
#
#         adjusted_price_final = price_after_amenity_adj + applied_feature_price_adjustment_total
#
#         recommended_price = max(0.0, adjusted_price_final)
#
#         print(f"Base price (best match): {best_price:.2f}")
#         print(f"Net amenity impact: {net_amenity_impact_percent:.2f}%")
#         print(f"Price after amenity adjustment (raw calculation): {price_after_amenity_adj_raw:.2f}")
#         if price_after_amenity_adj != price_after_amenity_adj_raw:
#             print(f"Price after amenity adjustment (after amenity cap): {price_after_amenity_adj:.2f}")
#         else:
#             print(f"Price after amenity adjustment (no amenity cap applied): {price_after_amenity_adj:.2f}")
#
#         print(f"Original AVG feature value adjustment: {original_feature_price_adjustment_total:.2f}")  # Changed log
#         if applied_feature_price_adjustment_total != original_feature_price_adjustment_total:
#             print(
#                 f"Applied AVG feature value adjustment (after feature cap): {applied_feature_price_adjustment_total:.2f}")  # Changed log
#         else:
#             print(
#                 f"Applied AVG feature value adjustment (no feature cap applied): {applied_feature_price_adjustment_total:.2f}")  # Changed log
#
#         print(f"Price before final 0.0 floor (AmenityAdjPrice + AppliedFeatureAdj): {adjusted_price_final:.2f}")
#         print(f"Final Recommended price: {recommended_price:.2f}")
#
#         return round(recommended_price, 2)
#
#     except Exception as e:
#         print(f"Unexpected error in get_recommended_price: {e}")
#         traceback.print_exc()
#         return 0.0

import pandas as pd
import json
import traceback

# Assuming filter200.py is in the same directory or accessible in PYTHONPATH
try:
    # Make sure the import matches the function signature if you have a placeholder
    from filter200 import select_comparables_for_pricing
except ImportError:
    print("Error: Could not import select_comparables_for_pricing from filter200.py.")


    # Define a placeholder if you want the script to run for testing other parts
    def select_comparables_for_pricing(df_global_processed, test_property_details,
                                       target_count=250):  # Match expected signature
        print(f"Placeholder select_comparables_for_pricing called. Returning original df_global_processed.")
        # Ensure placeholder returns a DataFrame
        if isinstance(df_global_processed, pd.DataFrame):
            return df_global_processed.head(target_count) if not df_global_processed.empty else pd.DataFrame()
        return pd.DataFrame()


def get_recommended_price(df: pd.DataFrame, test: pd.DataFrame) -> float:
    """
    Calculate recommended price based on property features and amenities,
    with capping for extremely negative amenity and feature impacts,
    and improved handling for feature mismatches where test property features
    are not well represented in the comparable dataset.

    Parameters:
    -----------
    df : DataFrame
        Reference properties with price data (comparables)
    test : DataFrame
        Single property for which to calculate the recommended price

    Returns:
    --------
    float : Recommended price
    """
    try:
        if df.empty or test.empty:
            print("Empty dataframe provided to get_recommended_price")
            return 0.0

        df = df.copy()
        test = test.copy()

        # --- STEP 1: Process amenities lists ---
        print("Processing amenities lists...")

        def safe_convert_amenities(amenities_val):
            try:
                if pd.isna(amenities_val): return []
                if isinstance(amenities_val, list): return [str(item).lower() for item in amenities_val]
                if isinstance(amenities_val, str):
                    try:
                        # Attempt to parse as JSON list first
                        result = json.loads(amenities_val)
                        if isinstance(result, list): return [str(item).lower() for item in result]
                    except (json.JSONDecodeError, TypeError):
                        # Fallback for comma-separated strings not in JSON list format
                        if '[' not in amenities_val and ']' not in amenities_val and ',' in amenities_val:
                            return [item.strip().lower() for item in amenities_val.split(',')]
                        return [amenities_val.lower()]  # Treat as a single amenity if not list-like
                return []  # Default to empty list for other types
            except Exception as e:
                print(f"Error in safe_convert_amenities for value '{amenities_val}': {e}")
                return []

        if "amenities_list" in df.columns:
            df["processed_amenities"] = df["amenities_list"].apply(safe_convert_amenities)
        elif "amenities" in df.columns:
            print("Warning: 'amenities_list' column not found in main dataframe, trying 'amenities'.")
            df["processed_amenities"] = df["amenities"].apply(safe_convert_amenities)
        else:
            print("Warning: Neither 'amenities_list' nor 'amenities' column found in main dataframe.")
            df["processed_amenities"] = pd.Series([[] for _ in range(len(df))], index=df.index)

        test_amenities_col_name = None
        if "amenities_list" in test.columns:
            test_amenities_col_name = "amenities_list"
        elif "amenities" in test.columns:
            test_amenities_col_name = "amenities"

        if test_amenities_col_name and not test[test_amenities_col_name].empty:
            test_amenities = safe_convert_amenities(test[test_amenities_col_name].iloc[0])
        else:
            print("Warning: Neither 'amenities_list' nor 'amenities' column found, or it's empty in test dataframe.")
            test_amenities = []
        print(f"Test property has {len(test_amenities)} amenities: {test_amenities[:5]}...")

        # --- STEP 2: Calculate amenity impacts ---
        print("Calculating amenity impacts...")
        all_amenities = set()
        for amenity_list_val in df["processed_amenities"]:  # Iterate over the series values
            if isinstance(amenity_list_val, list):  # Ensure it's a list before updating
                all_amenities.update(amenity_list_val)
        print(f"Found {len(all_amenities)} unique amenities in main df")

        amenity_impacts = {}
        if "price" not in df.columns:
            print("Error: 'price' column missing from main dataframe. Cannot calculate amenity impacts.")
        else:
            df["price"] = pd.to_numeric(df["price"], errors='coerce').fillna(0)
            for amenity in all_amenities:
                try:
                    has_amenity = df["processed_amenities"].apply(lambda x: isinstance(x, list) and amenity in x)
                except Exception as e:  # Should not happen if processed_amenities are all lists
                    print(f"Error checking amenity presence for '{amenity}': {e}")
                    continue

                if has_amenity.sum() > 0 and (~has_amenity).sum() > 0:
                    avg_price_with = df.loc[has_amenity, "price"].mean()
                    avg_price_without = df.loc[~has_amenity, "price"].mean()
                    if pd.notna(avg_price_with) and pd.notna(avg_price_without) and avg_price_without > 0:
                        impact = ((avg_price_with - avg_price_without) / avg_price_without) * 100
                        amenity_impacts[amenity] = round(impact, 2)
                    else:
                        amenity_impacts[amenity] = 0
                else:
                    amenity_impacts[amenity] = 0
        print(f"Calculated impacts for {len(amenity_impacts)} amenities.")

        # --- STEP 3: Calculate feature price averages ---
        print("Calculating feature price averages...")
        feature_price_means = {}
        feature_cols_for_pricing = ["beds", "bedrooms", "bathrooms", "guests"]
        if "price" in df.columns:  # df["price"] is already numeric and NaNs filled
            for col in feature_cols_for_pricing:
                if col in df.columns:
                    df[col] = pd.to_numeric(df[col], errors='coerce')  # Ensure feature col is numeric
                    valid_rows = df.dropna(subset=[col, "price"])
                    if not valid_rows.empty:
                        feature_price_means[col] = valid_rows.groupby(col)["price"].mean().to_dict()
                    else:
                        feature_price_means[col] = {}
                else:
                    print(f"Warning: Feature column '{col}' not found in main dataframe.")
                    feature_price_means[col] = {}
        else:
            print("Skipping feature price averages as 'price' column is missing.")

        # --- STEP 4 & 5 (Combined for brevity, logic unchanged) ---
        print("Calculating amenity and feature match scores for main df...")

        def calc_amenity_score(property_amenities_list):
            try:
                if not isinstance(property_amenities_list, list): return 0
                score = 0
                for amenity in property_amenities_list:
                    if amenity in test_amenities:  # test_amenities is already a set or list
                        score += amenity_impacts.get(amenity, 0)
                return score
            except Exception as e:
                print(f"Error in calc_amenity_score: {e}")
                return 0

        df["amenity_score"] = df["processed_amenities"].apply(calc_amenity_score)

        def calc_feature_score(row):
            try:
                score = 0
                # Ensure test property has the feature columns before trying to access them
                if not all(f_col in test.columns for f_col in feature_cols_for_pricing):
                    # print(f"Warning: Test property missing one or more feature columns for score calc: {feature_cols_for_pricing}")
                    return 0
                for col in feature_cols_for_pricing:
                    if col not in df.columns or col not in test.columns: continue  # Should be caught by above

                    from_val = pd.to_numeric(row[col], errors='coerce')
                    # Ensure test[col] is not empty before iloc[0]
                    if test[col].empty: continue
                    to_val = pd.to_numeric(test[col].iloc[0], errors='coerce')

                    if pd.isna(from_val) or pd.isna(to_val): continue

                    from_price = feature_price_means.get(col, {}).get(from_val, 0)
                    to_price = feature_price_means.get(col, {}).get(to_val, 0)
                    score += (to_price - from_price)
                return score
            except Exception as e:
                print(f"Error in calc_feature_score for row: {e}")
                return 0

        df["feature_score"] = df.apply(calc_feature_score, axis=1)

        # --- STEP 6: Find best matching property ---
        print("Finding best match...")
        df["total_score"] = df["amenity_score"] + df["feature_score"]
        if df.empty or df["total_score"].isna().all():
            print("Error: No properties found for comparison or all scores are NaN.")
            return 0.0
        # Ensure there's at least one row before iloc[0]
        df_sorted = df.sort_values("total_score", ascending=False, na_position='last')
        if df_sorted.empty:
            print("Error: No properties found after sorting for best match.")
            return 0.0
        best_match = df_sorted.iloc[0]

        best_price_raw = best_match.get("price", 0)  # price in df is already numeric
        best_price = pd.to_numeric(best_price_raw, errors='coerce')  # Redundant if df['price'] handled, but safe
        if pd.isna(best_price): best_price = 0.0
        print(f"Best match found with price: {best_price:.2f}")

        # --- STEP 7: Calculate price adjustments ---
        print("Calculating price adjustments...")
        test_amenities_set = set(test_amenities)  # Ensure test_amenities is a set for efficient lookup
        best_match_amenities_list = best_match.get('processed_amenities', [])
        if not isinstance(best_match_amenities_list, list): best_match_amenities_list = []
        best_amenities_set = set(best_match_amenities_list)

        missing_amenities = best_amenities_set - test_amenities_set
        extra_amenities = test_amenities_set - best_amenities_set
        missing_impact = sum(amenity_impacts.get(amenity, 0) for amenity in missing_amenities)
        extra_impact = sum(amenity_impacts.get(amenity, 0) for amenity in extra_amenities)
        net_amenity_impact_percent = extra_impact - missing_impact

        # Feature Adjustment (NEW LOGIC)
        feature_price_adjustment_total = 0
        print("    Feature Adjustments:")
        for col in feature_cols_for_pricing:
            if col not in test.columns or test[col].empty:
                print(f"      {col}: Skipping, column not in test property details or empty.")
                continue
            # best_match comes from df, which should have these columns if feature_price_means was populated
            if col not in best_match.index:  # Check if col is a valid key for best_match Series
                print(f"      {col}: Skipping, column not found in best_match property.")
                continue

            best_val_raw = best_match.get(col)
            test_val_raw = test[col].iloc[0]

            best_val_numeric = pd.to_numeric(best_val_raw, errors='coerce')
            test_val_numeric = pd.to_numeric(test_val_raw, errors='coerce')

            if pd.isna(best_val_numeric) or pd.isna(test_val_numeric):
                print(
                    f"      {col}: Skipping due to NaN values after conversion (Test: {test_val_raw}->{test_val_numeric}, BestMatch: {best_val_raw}->{best_val_numeric}).")
                continue

            best_price_avg_for_feature = feature_price_means.get(col, {}).get(best_val_numeric, 0)
            test_price_avg_for_feature_direct = feature_price_means.get(col, {}).get(test_val_numeric, 0)

            is_test_val_in_market_data = test_val_numeric in feature_price_means.get(col, {})
            current_feature_adjustment = 0

            if is_test_val_in_market_data:
                current_feature_adjustment = test_price_avg_for_feature_direct - best_price_avg_for_feature
                print(
                    f"      {col}: Test_Avg({test_val_numeric})={test_price_avg_for_feature_direct:.2f} - BestMatch_Avg({best_val_numeric})={best_price_avg_for_feature:.2f} = Adj: {current_feature_adjustment:.2f}")
            else:
                print(
                    f"      {col}: Test_val({test_val_numeric}) not in market data (avg price is effectively 0). BestMatch_val({best_val_numeric}) has avg price {best_price_avg_for_feature:.2f}.")

                if test_val_numeric > best_val_numeric:
                    price_for_0_units = feature_price_means.get(col, {}).get(0, 0)
                    price_for_1_unit = feature_price_means.get(col, {}).get(1, price_for_0_units)
                    value_of_first_unit = price_for_1_unit - price_for_0_units

                    if value_of_first_unit > 0:
                        additional_units = test_val_numeric - best_val_numeric
                        estimated_added_value = additional_units * value_of_first_unit
                        current_feature_adjustment = estimated_added_value
                        print(
                            f"        Extrapolating: ({test_val_numeric} - {best_val_numeric}) = {additional_units} extra unit(s) * {value_of_first_unit:.2f}/unit (0->1 unit val) = Est. Added Value: {current_feature_adjustment:.2f}")
                    else:
                        current_feature_adjustment = max(0, 0 - best_price_avg_for_feature)
                        print(
                            f"        Cannot determine positive 0->1 unit value for '{col}'. Test has more units. Adj capped at max(0, 0 - BestMatchAvg({best_price_avg_for_feature:.2f})): {current_feature_adjustment:.2f}")

                elif test_val_numeric < best_val_numeric:
                    current_feature_adjustment = 0
                    print(
                        f"        Test_val({test_val_numeric}) not in market, and is less than BestMatch_val({best_val_numeric}). Ignoring feature adjustment (0).")
                else:  # test_val_numeric == best_val_numeric
                    current_feature_adjustment = 0
                    print(
                        f"        Test_val({test_val_numeric}) not in market, and equals BestMatch_val({best_val_numeric}). Adjustment: 0.00")

            feature_price_adjustment_total += current_feature_adjustment
        print(f"    Total (Summed) Feature Adjustment before capping: {feature_price_adjustment_total:.2f}")

        # --- STEP 8: Calculate final recommended price with CAPPING ---
        print("Calculating final price...")
        price_after_amenity_adj_raw = best_price * (1 + net_amenity_impact_percent / 100.0)
        MIN_AMENITY_ADJUSTED_PRICE_RATIO_CAP = 0.05
        price_after_amenity_adj = price_after_amenity_adj_raw
        if best_price > 0:
            amenity_price_floor = best_price * MIN_AMENITY_ADJUSTED_PRICE_RATIO_CAP
            if price_after_amenity_adj_raw < amenity_price_floor:
                print(
                    f"    INFO: Amenity adjusted price capped. Original raw: {price_after_amenity_adj_raw:.2f}, Floor: {amenity_price_floor:.2f}")
                price_after_amenity_adj = amenity_price_floor
        price_after_amenity_adj = max(0.0, price_after_amenity_adj)  # Ensure non-negative

        original_feature_price_adjustment_total = feature_price_adjustment_total  # Store before cap
        applied_feature_price_adjustment_total = original_feature_price_adjustment_total
        MIN_FEATURE_ADJUSTED_PRICE_RATIO_CAP = 0.10  # e.g., price shouldn't drop more than 90% due to features

        if price_after_amenity_adj > 0:  # Only apply feature cap if price after amenity adj is positive
            # The lowest price allowed after feature adjustment
            feature_impact_floor_price = price_after_amenity_adj * MIN_FEATURE_ADJUSTED_PRICE_RATIO_CAP

            if price_after_amenity_adj + original_feature_price_adjustment_total < feature_impact_floor_price:
                # Recalculate the feature adjustment to meet the floor
                applied_feature_price_adjustment_total = feature_impact_floor_price - price_after_amenity_adj
                print(f"    INFO: Feature adjustment capped to prevent excessive reduction.")
                print(f"          Original feature adjustment: {original_feature_price_adjustment_total:.2f}")
                print(f"          Price after amenity adj (potentially capped): {price_after_amenity_adj:.2f}")
                print(f"          Feature impact floor price: {feature_impact_floor_price:.2f}")
                print(f"          Capped feature adjustment: {applied_feature_price_adjustment_total:.2f}")

        adjusted_price_final = price_after_amenity_adj + applied_feature_price_adjustment_total
        recommended_price = max(0.0, adjusted_price_final)  # Final absolute floor at 0.0

        print(f"Base price (best match): {best_price:.2f}")
        print(f"Net amenity impact: {net_amenity_impact_percent:.2f}%")
        print(f"Price after amenity adjustment (raw calculation): {price_after_amenity_adj_raw:.2f}")
        if abs(price_after_amenity_adj - price_after_amenity_adj_raw) > 0.001:  # Check if cap was applied
            print(f"Price after amenity adjustment (after amenity cap): {price_after_amenity_adj:.2f}")
        else:
            print(f"Price after amenity adjustment (no amenity cap applied): {price_after_amenity_adj:.2f}")

        print(f"Original feature value adjustment: {original_feature_price_adjustment_total:.2f}")
        if abs(applied_feature_price_adjustment_total - original_feature_price_adjustment_total) > 0.001:  # Check if cap was applied
            print(f"Applied feature value adjustment (after feature cap): {applied_feature_price_adjustment_total:.2f}")
        else:
            print(
                f"Applied feature value adjustment (no feature cap applied): {applied_feature_price_adjustment_total:.2f}")

        print(f"Price before final 0.0 floor (AmenityAdjPrice + AppliedFeatureAdj): {adjusted_price_final:.2f}")
        print(f"Final Recommended price: {recommended_price:.2f}")

        return round(recommended_price, 2)

    except Exception as e:
        print(f"Unexpected error in get_recommended_price: {e}")
        traceback.print_exc()
        return 0.0

